/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.parseable;

import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.progmodel.facets.object.parseable.ParseableFacetUsingParser;
import org.apache.isis.core.progmodel.facets.object.parseable.ParserUtil;

public abstract class ParseableFacetAbstract
extends FacetAbstract
implements ParseableFacet {
    private final Class<?> parserClass;
    private final ParseableFacetUsingParser parseableFacetUsingParser;

    public ParseableFacetAbstract(String candidateParserName, Class<?> candidateParserClass, FacetHolder holder, AuthenticationSessionProvider authenticationSessionProvider, DependencyInjector dependencyInjector, AdapterMap adapterManager) {
        super(ParseableFacet.class, holder, false);
        this.parserClass = ParserUtil.parserOrNull(candidateParserClass, candidateParserName);
        this.parseableFacetUsingParser = this.isValid() ? this.createParser(holder, authenticationSessionProvider, dependencyInjector, adapterManager) : null;
    }

    private ParseableFacetUsingParser createParser(FacetHolder holder, AuthenticationSessionProvider authenticationSessionProvider, DependencyInjector dependencyInjector, AdapterMap adapterManager) {
        Parser parser = (Parser)ClassUtil.newInstance(this.parserClass, FacetHolder.class, (Object)holder);
        return new ParseableFacetUsingParser(parser, holder, authenticationSessionProvider, dependencyInjector, adapterManager);
    }

    public boolean isValid() {
        return this.parserClass != null;
    }

    public Class<?> getParserClass() {
        return this.parserClass;
    }

    protected String toStringValues() {
        return this.parserClass.getName();
    }

    public ObjectAdapter parseTextEntry(ObjectAdapter original, String entryText) {
        return this.parseableFacetUsingParser.parseTextEntry(original, entryText);
    }

    public String parseableTitle(ObjectAdapter existing) {
        return this.parseableFacetUsingParser.parseableTitle(existing);
    }
}

