/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.ignore.javalang;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public abstract class AbstractRemoveMethodsFacetFactory
extends FacetFactoryAbstract {
    private final List<MethodAndParameterTypes> methodList = Lists.newArrayList();

    public AbstractRemoveMethodsFacetFactory(Class<?> typeToIgnore) {
        super(FeatureType.OBJECTS_ONLY);
        Method[] methods;
        for (Method method : methods = typeToIgnore.getMethods()) {
            this.methodList.add(new MethodAndParameterTypes(method.getName(), method.getParameterTypes()));
        }
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        for (MethodAndParameterTypes mapt : this.methodList) {
            processClassContext.removeMethod(MethodScope.OBJECT, mapt.methodName, null, mapt.methodParameters);
        }
    }

    private static class MethodAndParameterTypes {
        private final String methodName;
        private final Class<?>[] methodParameters;

        public MethodAndParameterTypes(String methodName, Class<?>[] methodParameters) {
            this.methodName = methodName;
            this.methodParameters = methodParameters;
        }
    }
}

