/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.hidden.method;

import java.lang.reflect.Method;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.hide.HiddenObjectFacet;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.object.hidden.method.HiddenObjectFacetViaHiddenMethod;

public class HiddenObjectViaHiddenMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String HIDDEN_PREFIX = "hidden";
    private static final String[] PREFIXES = new String[]{"hidden"};

    public HiddenObjectViaHiddenMethodFacetFactory() {
        super(FeatureType.EVERYTHING_BUT_PARAMETERS, PREFIXES);
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        for (Class returnType : new Class[]{Boolean.class, Boolean.TYPE}) {
            if (!this.addFacetIfMethodFound(processClassContext, returnType)) continue;
            return;
        }
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod member = (FacetedMethod)processMethodContext.getFacetHolder();
        Class owningClass = processMethodContext.getCls();
        ObjectSpecification owningSpec = this.getSpecificationLookup().loadSpecification(owningClass);
        HiddenObjectFacet facet = (HiddenObjectFacet)owningSpec.getFacet(HiddenObjectFacet.class);
        if (facet != null) {
            facet.copyOnto((FacetHolder)member);
        }
    }

    private boolean addFacetIfMethodFound(FacetFactory.ProcessClassContext processClassContext, Class<?> returnType) {
        Class cls = processClassContext.getCls();
        FacetHolder facetHolder = processClassContext.getFacetHolder();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, HIDDEN_PREFIX, returnType, NO_PARAMETERS_TYPES);
        if (method == null) {
            return false;
        }
        FacetUtil.addFacet((Facet)new HiddenObjectFacetViaHiddenMethod(method, facetHolder));
        processClassContext.removeMethod(method);
        return true;
    }
}

