/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.encodeable;

import org.apache.isis.applib.adapters.EncoderDecoder;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;

public class EncodableFacetUsingEncoderDecoder
extends FacetAbstract
implements EncodableFacet {
    private final EncoderDecoder<?> encoderDecoder;
    private final DependencyInjector dependencyInjector;
    private final AdapterMap adapterManager;
    public static String ENCODED_NULL = "NULL";

    public EncodableFacetUsingEncoderDecoder(EncoderDecoder<?> encoderDecoder, FacetHolder holder, AdapterMap adapterManager, DependencyInjector dependencyInjector) {
        super(EncodableFacet.class, holder, false);
        this.encoderDecoder = encoderDecoder;
        this.dependencyInjector = dependencyInjector;
        this.adapterManager = adapterManager;
    }

    protected String toStringValues() {
        this.getDependencyInjector().injectDependenciesInto(this.encoderDecoder);
        return this.encoderDecoder.toString();
    }

    public ObjectAdapter fromEncodedString(String encodedData) {
        Assert.assertNotNull((Object)encodedData);
        if (ENCODED_NULL.equals(encodedData)) {
            return null;
        }
        this.getDependencyInjector().injectDependenciesInto(this.encoderDecoder);
        Object decodedObject = this.encoderDecoder.fromEncodedString(encodedData);
        return this.getAdapterManager().adapterFor(decodedObject);
    }

    public String toEncodedString(ObjectAdapter adapter) {
        this.getDependencyInjector().injectDependenciesInto(this.encoderDecoder);
        return adapter == null ? ENCODED_NULL : EncodableFacetUsingEncoderDecoder.encode(this.encoderDecoder, adapter.getObject());
    }

    private static <T> String encode(EncoderDecoder<T> encoderDecoder, Object pojo) {
        Object pojoAsT = pojo;
        return encoderDecoder.toEncodedString(pojoAsT);
    }

    public DependencyInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    public AdapterMap getAdapterManager() {
        return this.adapterManager;
    }
}

