/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.encodeable;

import org.apache.isis.applib.annotation.Encodable;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.progmodel.facets.object.encodeable.EncodableFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.encodeable.EncoderDecoderUtil;

public class EncodableFacetAnnotation
extends EncodableFacetAbstract {
    private static String encoderDecoderName(Class<?> annotatedClass, IsisConfiguration configuration) {
        Encodable annotation = annotatedClass.getAnnotation(Encodable.class);
        String encoderDecoderName = annotation.encoderDecoderName();
        if (!StringUtils.isNullOrEmpty((String)encoderDecoderName)) {
            return encoderDecoderName;
        }
        return EncoderDecoderUtil.encoderDecoderNameFromConfiguration(annotatedClass, configuration);
    }

    private static Class<?> encoderDecoderClass(Class<?> annotatedClass) {
        Encodable annotation = annotatedClass.getAnnotation(Encodable.class);
        return annotation.encoderDecoderClass();
    }

    public EncodableFacetAnnotation(Class<?> annotatedClass, IsisConfiguration configuration, FacetHolder holder, AdapterMap adapterManager, DependencyInjector dependencyInjector) {
        this(EncodableFacetAnnotation.encoderDecoderName(annotatedClass, configuration), EncodableFacetAnnotation.encoderDecoderClass(annotatedClass), holder, adapterManager, dependencyInjector);
    }

    private EncodableFacetAnnotation(String candidateEncoderDecoderName, Class<?> candidateEncoderDecoderClass, FacetHolder holder, AdapterMap adapterManager, DependencyInjector dependencyInjector) {
        super(candidateEncoderDecoderName, candidateEncoderDecoderClass, holder, adapterManager, dependencyInjector);
    }
}

