/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.encodeable;

import org.apache.isis.applib.adapters.EncoderDecoder;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.progmodel.facets.object.encodeable.EncodableFacetUsingEncoderDecoder;
import org.apache.isis.core.progmodel.facets.object.encodeable.EncoderDecoderUtil;

public abstract class EncodableFacetAbstract
extends FacetAbstract
implements EncodableFacet {
    private final Class<?> encoderDecoderClass;
    private final EncodableFacetUsingEncoderDecoder encodeableFacetUsingEncoderDecoder;
    private final AdapterMap adapterMap;
    private final DependencyInjector dependencyInjector;

    public EncodableFacetAbstract(String candidateEncoderDecoderName, Class<?> candidateEncoderDecoderClass, FacetHolder holder, AdapterMap adapterManager, DependencyInjector dependencyInjector) {
        super(EncodableFacet.class, holder, false);
        this.adapterMap = adapterManager;
        this.dependencyInjector = dependencyInjector;
        this.encoderDecoderClass = EncoderDecoderUtil.encoderDecoderOrNull(candidateEncoderDecoderClass, candidateEncoderDecoderName);
        if (this.isValid()) {
            EncoderDecoder encoderDecoder = (EncoderDecoder)ClassUtil.newInstance(this.encoderDecoderClass, FacetHolder.class, (Object)holder);
            this.encodeableFacetUsingEncoderDecoder = new EncodableFacetUsingEncoderDecoder(encoderDecoder, holder, this.getAdapterMap(), this.getDependencyInjector());
        } else {
            this.encodeableFacetUsingEncoderDecoder = null;
        }
    }

    public boolean isValid() {
        return this.encoderDecoderClass != null;
    }

    public Class<?> getEncoderDecoderClass() {
        return this.encoderDecoderClass;
    }

    protected String toStringValues() {
        return this.encoderDecoderClass.getName();
    }

    public ObjectAdapter fromEncodedString(String encodedData) {
        return this.encodeableFacetUsingEncoderDecoder.fromEncodedString(encodedData);
    }

    public String toEncodedString(ObjectAdapter object) {
        return this.encodeableFacetUsingEncoderDecoder.toEncodedString(object);
    }

    public AdapterMap getAdapterMap() {
        return this.adapterMap;
    }

    public DependencyInjector getDependencyInjector() {
        return this.dependencyInjector;
    }
}

