/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.defaults.annotation;

import org.apache.isis.applib.annotation.Defaulted;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.AnnotationBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjectorAware;
import org.apache.isis.core.progmodel.facets.object.defaults.DefaultedFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.defaults.DefaultsProviderUtil;
import org.apache.isis.core.progmodel.facets.object.defaults.annotation.DefaultedFacetAnnotation;
import org.apache.isis.core.progmodel.facets.object.defaults.annotation.DefaultedFacetFromConfiguration;

public class DefaultedAnnotationFacetFactory
extends AnnotationBasedFacetFactoryAbstract
implements IsisConfigurationAware,
DependencyInjectorAware {
    private IsisConfiguration configuration;
    private DependencyInjector dependencyInjector;

    public DefaultedAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        FacetUtil.addFacet((Facet)this.create(processClassContext.getCls(), processClassContext.getFacetHolder()));
    }

    private DefaultedFacetAbstract create(Class<?> cls, FacetHolder holder) {
        DefaultedFacetFromConfiguration facet;
        DefaultedFacetAnnotation facet2;
        Defaulted annotation = (Defaulted)DefaultedAnnotationFacetFactory.getAnnotation(cls, Defaulted.class);
        if (annotation != null && (facet2 = new DefaultedFacetAnnotation(cls, this.getIsisConfiguration(), holder, this.getDependencyInjector())).isValid()) {
            return facet2;
        }
        String providerName = DefaultsProviderUtil.defaultsProviderNameFromConfiguration(cls, this.getIsisConfiguration());
        if (!StringUtils.isNullOrEmpty((String)providerName) && (facet = new DefaultedFacetFromConfiguration(providerName, holder, this.getDependencyInjector())).isValid()) {
            return facet;
        }
        return null;
    }

    public IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    public void setIsisConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    private DependencyInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    public void setDependencyInjector(DependencyInjector dependencyInjector) {
        this.dependencyInjector = dependencyInjector;
    }
}

