/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.choices.enums;

import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.progmodel.facets.object.choices.enums.EnumFacet;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;

public class EnumValueSemanticsProvider<T extends Enum<T>>
extends ValueSemanticsProviderAndFacetAbstract<T>
implements EnumFacet {
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private static final int TYPICAL_LENGTH = 8;

    private static Class<? extends Facet> type() {
        return EnumFacet.class;
    }

    public EnumValueSemanticsProvider() {
        this(null, null, null, null);
    }

    public EnumValueSemanticsProvider(FacetHolder holder, Class<T> adaptedClass, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        this(EnumValueSemanticsProvider.type(), holder, adaptedClass, 8, true, true, ((Enum[])adaptedClass.getEnumConstants())[0], configuration, context);
    }

    private EnumValueSemanticsProvider(Class<? extends Facet> adapterFacetType, FacetHolder holder, Class<T> adaptedClass, int typicalLength, boolean immutable, boolean equalByContent, T defaultValue, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(adapterFacetType, holder, adaptedClass, typicalLength, immutable, equalByContent, defaultValue, configuration, context);
    }

    @Override
    protected T doParse(Object context, String entry) {
        Enum[] enumConstants;
        for (Enum enumConstant : enumConstants = (Enum[])this.getAdaptedClass().getEnumConstants()) {
            if (!enumConstant.toString().equals(entry)) continue;
            return (T)enumConstant;
        }
        throw new TextEntryParseException("Unknown enum constant '" + entry + "'");
    }

    @Override
    protected String doEncode(Object object) {
        return this.titleString(object, null);
    }

    @Override
    protected T doRestore(String data) {
        return (T)this.doParse(null, data);
    }

    @Override
    protected String titleString(Object object, Localization localization) {
        return object.toString();
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(value, null);
    }
}

