/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.fallback;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.TypedHolder;
import org.apache.isis.core.progmodel.facets.fallback.ActionChoicesFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.ActionDefaultsFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.DescribedAsFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.ExecutedFacetAtDefault;
import org.apache.isis.core.progmodel.facets.fallback.HelpFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.MaxLengthFacetUnlimited;
import org.apache.isis.core.progmodel.facets.fallback.MultiLineFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.NamedFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.NotPersistableFacetNull;
import org.apache.isis.core.progmodel.facets.fallback.TitleFacetNone;

public class FallbackFacetFactory
extends FacetFactoryAbstract {
    private static final Map<Class<?>, Integer> TYPICAL_LENGTHS_BY_CLASS = new HashMap<Class<?>, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.putTypicalLength(Byte.TYPE, Byte.class, 3);
            this.putTypicalLength(Short.TYPE, Short.class, 5);
            this.putTypicalLength(Integer.TYPE, Integer.class, 10);
            this.putTypicalLength(Long.TYPE, Long.class, 20);
            this.putTypicalLength(Float.TYPE, Float.class, 20);
            this.putTypicalLength(Double.TYPE, Double.class, 20);
            this.putTypicalLength(Character.TYPE, Character.class, 1);
            this.putTypicalLength(Boolean.TYPE, Boolean.class, 1);
        }

        private void putTypicalLength(Class<?> primitiveClass, Class<?> wrapperClass, int length) {
            this.put(primitiveClass, length);
            this.put(wrapperClass, length);
        }
    };

    public FallbackFacetFactory() {
        super(FeatureType.EVERYTHING);
    }

    public boolean recognizes(Method method) {
        return false;
    }

    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetHolder facetHolder = processClassContaxt.getFacetHolder();
        DescribedAsFacetNone describedAsFacet = new DescribedAsFacetNone(facetHolder);
        NotPersistableFacetNull notPersistableFacet = new NotPersistableFacetNull(facetHolder);
        TitleFacetNone titleFacet = new TitleFacetNone(facetHolder);
        Facet[] facets = new Facet[]{describedAsFacet, notPersistableFacet, titleFacet};
        FacetUtil.addFacets((Facet[])facets);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        ArrayList<Object> facets = new ArrayList<Object>();
        if (processMethodContext.getFacetHolder() instanceof FacetedMethod) {
            facets.add((Object)new NamedFacetNone(processMethodContext.getFacetHolder()));
            facets.add((Object)new DescribedAsFacetNone(processMethodContext.getFacetHolder()));
            facets.add((Object)new HelpFacetNone(processMethodContext.getFacetHolder()));
            FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
            FeatureType featureType = facetedMethod.getFeatureType();
            if (featureType.isProperty()) {
                facets.add((Object)new MaxLengthFacetUnlimited(processMethodContext.getFacetHolder()));
                facets.add((Object)new MultiLineFacetNone(true, processMethodContext.getFacetHolder()));
            }
            if (featureType.isAction()) {
                facets.add((Object)new ExecutedFacetAtDefault(processMethodContext.getFacetHolder()));
                facets.add((Object)new ActionDefaultsFacetNone(processMethodContext.getFacetHolder()));
                facets.add((Object)new ActionChoicesFacetNone(processMethodContext.getFacetHolder()));
            }
        }
        FacetUtil.addFacets(facets);
    }

    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        TypedHolder typedHolder;
        ArrayList<Object> facets = new ArrayList<Object>();
        if (processParameterContext.getFacetHolder() instanceof TypedHolder && (typedHolder = (TypedHolder)processParameterContext.getFacetHolder()).getFeatureType().isActionParameter()) {
            facets.add((Object)new NamedFacetNone(processParameterContext.getFacetHolder()));
            facets.add((Object)new DescribedAsFacetNone(processParameterContext.getFacetHolder()));
            facets.add((Object)new HelpFacetNone(processParameterContext.getFacetHolder()));
            facets.add((Object)new MultiLineFacetNone(false, processParameterContext.getFacetHolder()));
            facets.add((Object)new MaxLengthFacetUnlimited(processParameterContext.getFacetHolder()));
        }
        FacetUtil.addFacets(facets);
    }
}

