/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;

public final class MethodFinderUtils {
    private MethodFinderUtils() {
    }

    public static Method findMethodWithOrWithoutParameters(Class<?> type, MethodScope classMethod, String name, Class<?> returnType, Class<?>[] paramTypes) {
        Method method = MethodFinderUtils.findMethod(type, classMethod, name, returnType, paramTypes);
        if (method == null) {
            method = MethodFinderUtils.findMethod(type, classMethod, name, returnType, MethodPrefixBasedFacetFactoryAbstract.NO_PARAMETERS_TYPES);
        }
        return method;
    }

    public static Method findMethod(Class<?> type, MethodScope methodScope, String name, Class<?> returnType, Class<?>[] paramTypes) {
        Method method;
        try {
            method = type.getMethod(name, paramTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return null;
        }
        if (!methodScope.matchesScopeOf(method)) {
            return null;
        }
        if (!method.getName().equals(name)) {
            return null;
        }
        if (returnType != null && returnType != method.getReturnType()) {
            return null;
        }
        if (paramTypes != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (paramTypes.length != parameterTypes.length) {
                return null;
            }
            for (int c = 0; c < paramTypes.length; ++c) {
                if (paramTypes[c] == null || paramTypes[c] == parameterTypes[c]) continue;
                return null;
            }
        }
        return method;
    }

    protected static boolean doesNotMatchScope(MethodScope methodScope, Method method) {
        return methodScope.doesNotMatchScope(method);
    }

    public static Method findMethod(Class<?> type, MethodScope methodScope, String name, Class<?> returnType) {
        try {
            Method[] methods;
            for (Method method2 : methods = type.getMethods()) {
                Method method = method2;
                int modifiers = method.getModifiers();
                if (!Modifier.isPublic(modifiers) || !methodScope.matchesScopeOf(method) || !method.getName().equals(name) || returnType != null && returnType != method.getReturnType()) continue;
                return method;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        return null;
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, MethodScope methodScope, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        if (type == null || methodScope == null || annotationClass == null) {
            throw new IllegalArgumentException("One or more arguments are 'null' valued");
        }
        for (Method method : type.getMethods()) {
            if (!methodScope.matchesScopeOf(method) || !method.isAnnotationPresent(annotationClass)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static void removeMethod(MethodRemover methodRemover, Method method) {
        if (methodRemover != null && method != null) {
            methodRemover.removeMethod(method);
        }
    }

    public static Class<?>[] paramTypesOrNull(Class<?> type) {
        Class[] classArray;
        if (type == null) {
            classArray = null;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type;
        }
        return classArray;
    }

    public static boolean allParametersOfSameType(Class<?>[] params) {
        Class<?> firstParam = params[0];
        for (int i = 1; i < params.length; ++i) {
            if (params[i] == firstParam) continue;
            return false;
        }
        return true;
    }
}

