/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.util;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebugString;
import org.apache.isis.core.commons.debug.DebugUtils;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.object.bounded.BoundedFacetUtils;
import org.apache.isis.core.metamodel.facets.object.cached.CachedFacetUtils;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacetUtils;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionContainer;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociationFilters;

public final class Dump {
    private static DebugBuilder debugBuilder;

    private Dump() {
    }

    public static String specification(ObjectAdapter adapter) {
        DebugString debugBuilder = new DebugString();
        Dump.specification(adapter, (DebugBuilder)debugBuilder);
        return debugBuilder.toString();
    }

    public static void specification(ObjectAdapter adapter, DebugBuilder debugBuilder) {
        ObjectSpecification specification = adapter.getSpecification();
        Dump.specification(specification, debugBuilder);
    }

    public static void specification(ObjectSpecification specification, DebugBuilder debugBuilder) {
        try {
            debugBuilder.appendTitle(specification.getClass().getName());
            debugBuilder.appendAsHexln("Hash code", (long)specification.hashCode());
            debugBuilder.appendln("ID", (Object)specification.getIdentifier());
            debugBuilder.appendln("Full Name", (Object)specification.getFullIdentifier());
            debugBuilder.appendln("Short Name", (Object)specification.getShortIdentifier());
            debugBuilder.appendln("Singular Name", (Object)specification.getSingularName());
            debugBuilder.appendln("Plural Name", (Object)specification.getPluralName());
            debugBuilder.appendln("Description", (Object)specification.getDescription());
            debugBuilder.blankLine();
            debugBuilder.appendln("Features", (Object)Dump.featureList(specification));
            debugBuilder.appendln("Type", (Object)(specification.isCollection() ? "Collection" : "Object"));
            if (specification.superclass() != null) {
                debugBuilder.appendln("Superclass", (Object)specification.superclass().getFullIdentifier());
            }
            debugBuilder.appendln("Interfaces", (Object[])Dump.specificationNames(specification.interfaces()));
            debugBuilder.appendln("Subclasses", (Object[])Dump.specificationNames(specification.subclasses()));
            debugBuilder.blankLine();
            debugBuilder.appendln("Service", specification.isService());
            debugBuilder.appendln("Encodable", specification.isEncodeable());
            debugBuilder.appendln("Parseable", specification.isParseable());
            debugBuilder.appendln("Aggregated", specification.isValueOrIsAggregated());
        }
        catch (RuntimeException e) {
            debugBuilder.appendException((Throwable)e);
        }
        if (specification instanceof DebuggableWithTitle) {
            ((DebuggableWithTitle)specification).debugData(debugBuilder);
        }
        debugBuilder.blankLine();
        debugBuilder.appendln("Facets");
        Class<? extends Facet>[] facetTypes = specification.getFacetTypes();
        debugBuilder.indent();
        if (facetTypes.length == 0) {
            debugBuilder.appendln("none");
        } else {
            for (Class<? extends Facet> type : facetTypes) {
                Facet facet = specification.getFacet(type);
                debugBuilder.appendln(facet.toString());
            }
        }
        debugBuilder.unindent();
        debugBuilder.blankLine();
        debugBuilder.appendln("Fields");
        debugBuilder.indent();
        Dump.specificationFields(specification, debugBuilder);
        debugBuilder.unindent();
        debugBuilder.appendln("Object Actions");
        debugBuilder.indent();
        Dump.specificationActionMethods(specification, debugBuilder);
        debugBuilder.unindent();
        debugBuilder.appendln("Related Service Actions");
        debugBuilder.indent();
        Dump.specificationServiceMethods(specification, debugBuilder);
        debugBuilder.unindent();
    }

    private static String[] specificationNames(List<ObjectSpecification> specifications) {
        String[] names = new String[specifications.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = specifications.get(i).getFullIdentifier();
        }
        return names;
    }

    private static void specificationActionMethods(ObjectSpecification specification, DebugBuilder debugBuilder) {
        try {
            List<ObjectAction> userActions = specification.getObjectActions(ActionType.USER, ObjectActionContainer.Contributed.INCLUDED);
            List<ObjectAction> explActions = specification.getObjectActions(ActionType.EXPLORATION, ObjectActionContainer.Contributed.INCLUDED);
            List<ObjectAction> prototypeActions = specification.getObjectActions(ActionType.PROTOTYPE, ObjectActionContainer.Contributed.INCLUDED);
            List<ObjectAction> debActions = specification.getObjectActions(ActionType.DEBUG, ObjectActionContainer.Contributed.INCLUDED);
            Dump.specificationMethods(userActions, explActions, prototypeActions, debActions, debugBuilder);
        }
        catch (RuntimeException e) {
            debugBuilder.appendException((Throwable)e);
        }
    }

    private static void specificationServiceMethods(ObjectSpecification specification, DebugBuilder debugBuilder) {
        try {
            List<ObjectAction> userActions = specification.getServiceActionsReturning(ActionType.USER);
            List<ObjectAction> explActions = specification.getServiceActionsReturning(ActionType.EXPLORATION);
            List<ObjectAction> prototypeActions = specification.getServiceActionsReturning(ActionType.PROTOTYPE);
            List<ObjectAction> debActions = specification.getServiceActionsReturning(ActionType.DEBUG);
            Dump.specificationMethods(userActions, explActions, prototypeActions, debActions, debugBuilder);
        }
        catch (RuntimeException e) {
            debugBuilder.appendException((Throwable)e);
        }
    }

    private static void specificationFields(ObjectSpecification specification, DebugBuilder debugBuilder) {
        int i;
        List<ObjectAssociation> fields = specification.getAssociations();
        debugBuilder.appendln("All");
        debugBuilder.indent();
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            debugBuilder.appendln(i2 + 1 + "." + fields.get(i2).getId());
        }
        debugBuilder.unindent();
        List<ObjectAssociation> fields2 = specification.getAssociations(ObjectAssociationFilters.STATICALLY_VISIBLE_ASSOCIATIONS);
        debugBuilder.appendln("Static");
        debugBuilder.indent();
        for (i = 0; i < fields2.size(); ++i) {
            debugBuilder.appendln(i + 1 + "." + fields2.get(i).getId());
        }
        debugBuilder.unindent();
        debugBuilder.appendln();
        try {
            if (fields.size() == 0) {
                debugBuilder.appendln("none");
            } else {
                for (i = 0; i < fields.size(); ++i) {
                    String help;
                    ObjectAssociation field = fields.get(i);
                    debugBuilder.appendln(i + 1 + "." + field.getId() + "  (" + field.getClass().getName() + ")");
                    debugBuilder.indent();
                    String description = field.getDescription();
                    if (description != null && !description.equals("")) {
                        debugBuilder.appendln("Description", (Object)description);
                    }
                    if ((help = field.getHelp()) != null && !help.equals("")) {
                        debugBuilder.appendln("Help", (Object)(help.substring(0, Math.min(30, help.length())) + (help.length() > 30 ? "..." : "")));
                    }
                    debugBuilder.appendln("ID", (Object)field.getIdentifier());
                    debugBuilder.appendln("Short ID", (Object)field.getId());
                    debugBuilder.appendln("Name", (Object)field.getName());
                    String type = field.isOneToManyAssociation() ? "Collection" : (field.isOneToOneAssociation() ? "Object" : "Unknown");
                    debugBuilder.appendln("Type", (Object)type);
                    debugBuilder.appendln("Has identity", !field.getSpecification().isCollectionOrIsAggregated());
                    debugBuilder.appendln("Spec", (Object)field.getSpecification().getFullIdentifier());
                    debugBuilder.appendln("Flags", (Object)((field.isAlwaysHidden() ? "" : "Visible ") + (field.isNotPersisted() ? "Not Persisted " : " ") + (field.isMandatory() ? "Mandatory " : "")));
                    Class<? extends Facet>[] facets = field.getFacetTypes();
                    if (facets.length > 0) {
                        debugBuilder.appendln("Facets");
                        debugBuilder.indent();
                        boolean none = true;
                        for (Class<? extends Facet> facet : facets) {
                            debugBuilder.appendln(field.getFacet(facet).toString());
                            none = false;
                        }
                        if (none) {
                            debugBuilder.appendln("none");
                        }
                        debugBuilder.unindent();
                    }
                    debugBuilder.appendln(field.debugData());
                    debugBuilder.unindent();
                }
            }
        }
        catch (RuntimeException e) {
            debugBuilder.appendException((Throwable)e);
        }
    }

    private static void specificationMethods(List<ObjectAction> userActions, List<ObjectAction> explActions, List<ObjectAction> prototypeActions, List<ObjectAction> debugActions, DebugBuilder debugBuilder) {
        if (userActions.size() == 0 && explActions.size() == 0 && prototypeActions.size() == 0 && debugActions.size() == 0) {
            debugBuilder.appendln("no actions...");
        } else {
            Dump.appendActionDetails(debugBuilder, "User actions", userActions);
            Dump.appendActionDetails(debugBuilder, "Exploration actions", explActions);
            Dump.appendActionDetails(debugBuilder, "Prototype actions", prototypeActions);
            Dump.appendActionDetails(debugBuilder, "Debug actions", debugActions);
        }
    }

    private static void appendActionDetails(DebugBuilder debug, String desc, List<ObjectAction> actions) {
        debug.appendln(desc);
        debug.indent();
        for (int i = 0; i < actions.size(); ++i) {
            Dump.actionDetails(actions.get(i), 8, i, debug);
        }
        debug.unindent();
    }

    private static void actionDetails(ObjectAction objectAction, int indent, int count, DebugBuilder debugBuilder) {
        debugBuilder.appendln(count + 1 + "." + objectAction.getId() + " (" + objectAction.getClass().getName() + ")");
        debugBuilder.indent();
        int newIndent = indent + 4;
        try {
            List<ObjectAction> debActions = objectAction.getActions();
            if (debActions.size() > 0) {
                for (int i = 0; i < debActions.size(); ++i) {
                    Dump.actionDetails(debActions.get(i), newIndent, i, debugBuilder);
                }
            } else {
                ObjectSpecification returnType;
                if (objectAction.getDescription() != null && !objectAction.getDescription().equals("")) {
                    debugBuilder.appendln("Description", (Object)objectAction.getDescription());
                }
                debugBuilder.appendln("ID", (Object)objectAction.getId());
                debugBuilder.appendln(objectAction.debugData());
                debugBuilder.appendln("Target", (Object)objectAction.getTarget());
                debugBuilder.appendln("On type", (Object)objectAction.getOnType());
                Class<? extends Facet>[] facets = objectAction.getFacetTypes();
                if (facets.length > 0) {
                    debugBuilder.appendln("Facets");
                    debugBuilder.indent();
                    for (Class<? extends Facet> facet : facets) {
                        debugBuilder.appendln(objectAction.getFacet(facet).toString());
                    }
                    debugBuilder.unindent();
                }
                debugBuilder.appendln("Returns", (Object)((returnType = objectAction.getReturnType()) == null ? "VOID" : returnType.toString()));
                List<ObjectActionParameter> parameters = objectAction.getParameters();
                if (parameters.size() == 0) {
                    debugBuilder.appendln("Parameters", (Object)"none");
                } else {
                    debugBuilder.appendln("Parameters");
                    debugBuilder.indent();
                    List<ObjectActionParameter> p = objectAction.getParameters();
                    for (int j = 0; j < parameters.size(); ++j) {
                        Class<? extends Facet>[] parameterFacets;
                        debugBuilder.append((Object)p.get(j).getName());
                        debugBuilder.append((Object)" (");
                        debugBuilder.append((Object)parameters.get(j).getSpecification().getFullIdentifier());
                        debugBuilder.appendln(")");
                        debugBuilder.indent();
                        for (Class<? extends Facet> parameterFacet : parameterFacets = p.get(j).getFacetTypes()) {
                            debugBuilder.appendln(p.get(j).getFacet(parameterFacet).toString());
                        }
                        debugBuilder.unindent();
                    }
                    debugBuilder.unindent();
                }
            }
        }
        catch (RuntimeException e) {
            debugBuilder.appendException((Throwable)e);
        }
        debugBuilder.unindent();
    }

    private static String featureList(ObjectSpecification specification) {
        StringBuilder str = new StringBuilder();
        if (specification.isAbstract()) {
            str.append("Abstract ");
        }
        if (BoundedFacetUtils.isBoundedSet(specification)) {
            str.append("Bounded ");
        }
        if (CachedFacetUtils.isCached(specification)) {
            str.append("Cached ");
        }
        if (ImmutableFacetUtils.isAlwaysImmutable(specification)) {
            str.append("Immutable (always) ");
        }
        if (ImmutableFacetUtils.isImmutableOncePersisted(specification)) {
            str.append("Immutable (once persisted) ");
        }
        if (specification.isService()) {
            str.append("Service ");
        }
        return str.toString();
    }

    public static String adapter(ObjectAdapter adapter) {
        DebugString debugBuilder = new DebugString();
        Dump.adapter(adapter, (DebugBuilder)debugBuilder);
        return debugBuilder.toString();
    }

    public static void adapter(ObjectAdapter adapter, DebugBuilder builder) {
        try {
            builder.appendln("Adapter", (Object)adapter.getClass().getName());
            builder.appendln("Class", (Object)(adapter.getObject() == null ? "none" : adapter.getObject().getClass().getName()));
            builder.appendAsHexln("Hash", (long)adapter.hashCode());
            builder.appendln("Object", adapter.getObject());
            builder.appendln("Title", (Object)adapter.titleString());
            builder.appendln("Specification", (Object)adapter.getSpecification().getFullIdentifier());
            builder.appendln();
            builder.appendln("Icon", (Object)adapter.getIconName());
            builder.appendln("OID", (Object)adapter.getOid());
            builder.appendln("State", (Object)adapter.getResolveState());
            builder.appendln("Version", (Object)adapter.getVersion());
        }
        catch (RuntimeException e) {
            builder.appendException((Throwable)e);
        }
    }

    public static String graph(ObjectAdapter adapter, AuthenticationSession authenticationSession) {
        debugBuilder = new DebugString();
        Dump.graph(adapter, authenticationSession, debugBuilder);
        return debugBuilder.toString();
    }

    public static void graph(ObjectAdapter object, AuthenticationSession authenticationSession, DebugBuilder debugBuilder) {
        Dump.simpleObject(object, debugBuilder);
        debugBuilder.appendln();
        debugBuilder.append((Object)object);
        Dump.graph(object, 0, Lists.newArrayList(), authenticationSession, debugBuilder);
    }

    private static void simpleObject(ObjectAdapter collectionAdapter, DebugBuilder debugBuilder) {
        debugBuilder.appendln(collectionAdapter.titleString());
        ObjectSpecification objectSpec = collectionAdapter.getSpecification();
        if (objectSpec.isCollection()) {
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collectionAdapter);
            int i = 1;
            for (ObjectAdapter element : facet.collection(collectionAdapter)) {
                debugBuilder.appendln(i++ + " " + element.titleString());
            }
        } else {
            try {
                List<ObjectAssociation> fields = objectSpec.getAssociations();
                for (int i = 0; i < fields.size(); ++i) {
                    ObjectAssociation field = fields.get(i);
                    ObjectAdapter obj = field.get(collectionAdapter);
                    String name = field.getId();
                    if (obj == null) {
                        debugBuilder.appendln(name, (Object)"null");
                        continue;
                    }
                    debugBuilder.appendln(name, (Object)obj.titleString());
                }
            }
            catch (RuntimeException e) {
                debugBuilder.appendException((Throwable)e);
            }
        }
    }

    private static void collectionGraph(ObjectAdapter collectionAdapter, int level, List<ObjectAdapter> ignoreAdapters, AuthenticationSession authenticationSession, DebugBuilder debugBuilder) {
        if (ignoreAdapters.contains(collectionAdapter)) {
            debugBuilder.append((Object)"*\n");
        } else {
            ignoreAdapters.add(collectionAdapter);
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collectionAdapter);
            for (ObjectAdapter element : facet.collection(collectionAdapter)) {
                Dump.graphIndent(level, debugBuilder);
                debugBuilder.append((Object)element);
                if (ignoreAdapters.contains(element)) {
                    debugBuilder.append((Object)"*\n");
                    continue;
                }
                Dump.graph(element, level + 1, ignoreAdapters, authenticationSession, debugBuilder);
            }
        }
    }

    private static void graph(ObjectAdapter adapter, int level, List<ObjectAdapter> ignoreAdapters, AuthenticationSession authenticationSession, DebugBuilder debugBuilder) {
        if (level > 3) {
            debugBuilder.appendln("...");
        } else {
            debugBuilder.append((Object)"\n");
            if (adapter.getSpecification().isCollection()) {
                Dump.collectionGraph(adapter, level, ignoreAdapters, authenticationSession, debugBuilder);
            } else if (adapter.getSpecification().isNotCollection()) {
                Dump.objectGraph(adapter, level, ignoreAdapters, debugBuilder, authenticationSession);
            } else {
                debugBuilder.append((Object)("??? " + adapter));
            }
        }
    }

    private static void graphIndent(int level, DebugBuilder debugBuilder) {
        for (int indent = 0; indent < level; ++indent) {
            debugBuilder.append((Object)(DebugUtils.indentString((int)4) + "|"));
        }
        debugBuilder.append((Object)(DebugUtils.indentString((int)4) + "+--"));
    }

    private static void objectGraph(ObjectAdapter adapter, int level, List<ObjectAdapter> ignoreAdapters, DebugBuilder s, AuthenticationSession authenticationSession) {
        ignoreAdapters.add(adapter);
        try {
            List<ObjectAssociation> fields = adapter.getSpecification().getAssociations();
            for (int i = 0; i < fields.size(); ++i) {
                ObjectAssociation field = fields.get(i);
                ObjectAdapter obj = field.get(adapter);
                String name = field.getId();
                Dump.graphIndent(level, s);
                if (field.isVisible(authenticationSession, adapter).isVetoed()) {
                    s.append((Object)(name + ": (not visible)"));
                    s.append((Object)"\n");
                    continue;
                }
                if (obj == null) {
                    s.append((Object)(name + ": null\n"));
                    continue;
                }
                if (ignoreAdapters.contains(obj)) {
                    s.append((Object)(name + ": " + obj + "*\n"));
                    continue;
                }
                s.append((Object)(name + ": " + obj));
                Dump.graph(obj, level + 1, ignoreAdapters, authenticationSession, s);
            }
        }
        catch (RuntimeException e) {
            s.appendException((Throwable)e);
        }
    }
}

