/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl.dflt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.commons.lang.ListUtils;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.ImperativeFacetUtils;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacetInferred;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackUtils;
import org.apache.isis.core.metamodel.facets.object.callbacks.CreatedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.icon.IconFacet;
import org.apache.isis.core.metamodel.facets.object.plural.PluralFacet;
import org.apache.isis.core.metamodel.facets.object.plural.PluralFacetInferred;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.layout.MemberLayoutArranger;
import org.apache.isis.core.metamodel.layout.OrderSet;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectActionSet;
import org.apache.isis.core.metamodel.spec.ObjectInstantiationException;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecificationException;
import org.apache.isis.core.metamodel.spec.SpecificationContext;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionContainer;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.specimpl.CreateObjectContext;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilder;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilderContext;
import org.apache.isis.core.metamodel.specloader.specimpl.IntrospectionContext;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectSpecificationAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyAssociationImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneAssociationImpl;
import org.apache.log4j.Logger;

public class ObjectSpecificationDefault
extends ObjectSpecificationAbstract
implements DebuggableWithTitle,
FacetHolder {
    private static final Logger LOG = Logger.getLogger(ObjectSpecificationDefault.class);
    private boolean isService;
    private Map<Method, ObjectMember> membersByMethod = null;
    private final ObjectMemberContext objectMemberContext;
    private final IntrospectionContext introspectionContext;
    private final CreateObjectContext createObjectContext;
    private FacetedMethodsBuilder facetedMethodsBuilder;

    private static String determineShortName(Class<?> introspectedClass) {
        String name = introspectedClass.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public ObjectSpecificationDefault(Class<?> correspondingClass, FacetedMethodsBuilderContext facetedMethodsBuilderContext, IntrospectionContext introspectionContext, SpecificationContext specContext, ObjectMemberContext objectMemberContext, CreateObjectContext createObjectContext) {
        super(correspondingClass, ObjectSpecificationDefault.determineShortName(correspondingClass), specContext);
        this.facetedMethodsBuilder = new FacetedMethodsBuilder(this, facetedMethodsBuilderContext);
        this.introspectionContext = introspectionContext;
        this.createObjectContext = createObjectContext;
        this.objectMemberContext = objectMemberContext;
    }

    @Override
    public void introspectTypeHierarchyAndMembers() {
        boolean skipFurtherIntrospection;
        if (this.facetedMethodsBuilder == null) {
            throw new MetaModelException("Introspection already taken place, cannot introspect again");
        }
        this.facetedMethodsBuilder.introspectClass();
        this.addNamedFacetAndPluralFacetIfRequired();
        Class<?> superclass = this.getCorrespondingClass().getSuperclass();
        this.setSuperclass(superclass);
        boolean bl = skipFurtherIntrospection = JavaClassUtils.isJavaClass(this.getCorrespondingClass()) || this.isAppLibValue(this.getCorrespondingClass());
        if (skipFurtherIntrospection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("skipping introspection of interfaces, properties, actions and interfaces for " + this.getFullIdentifier() + " (java.xxx or applib value class)"));
            }
            return;
        }
        Class<?>[] interfaceTypes = this.getCorrespondingClass().getInterfaces();
        ArrayList interfaceSpecList = Lists.newArrayList();
        for (Class<?> interfaceType : interfaceTypes) {
            Class<?> substitutedInterfaceType = this.getClassSubstitutor().getClass(interfaceType);
            if (substitutedInterfaceType == null) continue;
            ObjectSpecification interfaceSpec = this.getSpecificationLookup().loadSpecification(substitutedInterfaceType);
            interfaceSpecList.add(interfaceSpec);
        }
        this.addAsSubclassTo(interfaceSpecList);
        this.addInterfaces(interfaceSpecList);
        List<FacetedMethod> associationFacetedMethods = this.facetedMethodsBuilder.getAssociationFacetedMethods();
        List<FacetedMethod> actionFacetedMethods = this.facetedMethodsBuilder.getActionFacetedMethods();
        OrderSet associationOrderSet = this.getMemberLayoutArranger().createAssociationOrderSetFor(this, associationFacetedMethods);
        this.addAssociations(this.asAssociations(associationOrderSet));
        OrderSet actionOrderSet = this.getMemberLayoutArranger().createActionOrderSetFor(this, actionFacetedMethods);
        this.addObjectActions(this.asObjectActions(actionOrderSet));
        this.updateFromFacetValues();
        this.facetedMethodsBuilder = null;
        this.setIntrospected(true);
    }

    private void addNamedFacetAndPluralFacetIfRequired() {
        PluralFacet pluralFacet;
        NamedFacet namedFacet = this.getFacet(NamedFacet.class);
        if (namedFacet == null) {
            namedFacet = new NamedFacetInferred(NameUtils.naturalName((String)this.getShortIdentifier()), this);
            this.addFacet(namedFacet);
        }
        if ((pluralFacet = this.getFacet(PluralFacet.class)) == null) {
            pluralFacet = new PluralFacetInferred(NameUtils.pluralName((String)namedFacet.value()), this);
            this.addFacet(pluralFacet);
        }
    }

    private boolean isAppLibValue(Class<?> type) {
        return type.getName().startsWith("org.apache.isis.applib.value.");
    }

    private List<ObjectAssociation> asAssociations(OrderSet orderSet) {
        if (orderSet == null) {
            return null;
        }
        ArrayList associations = Lists.newArrayList();
        for (Object element : orderSet) {
            if (element instanceof FacetedMethod) {
                FacetedMethod facetMethod = (FacetedMethod)element;
                if (facetMethod.getFeatureType().isCollection()) {
                    associations.add(this.createCollection(facetMethod));
                    continue;
                }
                if (!facetMethod.getFeatureType().isProperty()) continue;
                associations.add(this.createProperty(facetMethod));
                continue;
            }
            if (element instanceof OrderSet) continue;
            throw new UnknownTypeException(element);
        }
        return associations;
    }

    private List<ObjectAction> asObjectActions(OrderSet orderSet) {
        if (orderSet == null) {
            return null;
        }
        ArrayList actions = Lists.newArrayList();
        for (Object element : orderSet) {
            if (element instanceof FacetedMethod) {
                FacetedMethod facetedMethod = (FacetedMethod)element;
                if (!facetedMethod.getFeatureType().isAction()) continue;
                actions.add(this.createAction(facetedMethod));
                continue;
            }
            if (element instanceof OrderSet) {
                OrderSet set = (OrderSet)element;
                actions.add(this.createObjectActionSet(set));
                continue;
            }
            throw new UnknownTypeException(element);
        }
        return actions;
    }

    private OneToOneAssociationImpl createProperty(FacetedMethod facetedMethod) {
        return new OneToOneAssociationImpl(facetedMethod, this.objectMemberContext);
    }

    private OneToManyAssociationImpl createCollection(FacetedMethod facetedMethod) {
        return new OneToManyAssociationImpl(facetedMethod, this.objectMemberContext);
    }

    private ObjectAction createAction(FacetedMethod facetedMethod) {
        return new ObjectActionImpl(facetedMethod, this.objectMemberContext, this.getServicesProvider());
    }

    private ObjectActionSet createObjectActionSet(OrderSet set) {
        return new ObjectActionSet("", set.getGroupFullName(), this.asObjectActions(set));
    }

    @Override
    public boolean isIntrospected() {
        return this.facetedMethodsBuilder == null;
    }

    @Override
    public boolean isService() {
        return this.isService;
    }

    @Override
    public void markAsService() {
        this.ensureServiceHasNoAssociations();
        this.isService = true;
    }

    private void ensureServiceHasNoAssociations() {
        List<ObjectAssociation> associations = this.getAssociations();
        StringBuilder buf = new StringBuilder();
        for (ObjectAssociation association : associations) {
            String name = association.getId();
            if (this.isValidAssociationForService(name)) continue;
            this.appendAssociationName(buf, name);
        }
        if (buf.length() > 0) {
            throw new ObjectSpecificationException("Service object " + this.getFullIdentifier() + " should have no fields, but has: " + buf);
        }
    }

    private boolean isValidAssociationForService(String associationId) {
        return "id".indexOf(associationId) != -1;
    }

    private void appendAssociationName(StringBuilder fieldNames, String name) {
        fieldNames.append(fieldNames.length() > 0 ? ", " : "");
        fieldNames.append(name);
    }

    @Override
    public ObjectAction getObjectAction(ActionType type, String id, List<ObjectSpecification> parameters) {
        List availableActions = ListUtils.combine(this.getObjectActions(ObjectActionContainer.Contributed.EXCLUDED), this.getContributedActions(type));
        return this.getAction(availableActions, type, id, parameters);
    }

    @Override
    public ObjectAction getObjectAction(ActionType type, String id) {
        List availableActions = ListUtils.combine(this.getObjectActions(type, ObjectActionContainer.Contributed.INCLUDED), this.getContributedActions(type));
        return this.getAction(availableActions, type, id);
    }

    @Override
    public ObjectAction getObjectAction(String id) {
        for (ActionType type : ActionType.values()) {
            ObjectAction action = this.getObjectAction(type, id);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    private ObjectAction getAction(List<ObjectAction> availableActions, ActionType type, String actionName, List<ObjectSpecification> parameters) {
        block0: for (int i = 0; i < availableActions.size(); ++i) {
            ObjectAction action = availableActions.get(i);
            if (action.getActions().size() > 0) {
                ObjectAction a = this.getAction(action.getActions(), type, actionName, parameters);
                if (a == null) continue;
                return a;
            }
            if (!action.getType().equals((Object)type) || actionName != null && !actionName.equals(action.getId()) || action.getParameters().size() != parameters.size()) continue;
            for (int j = 0; j < parameters.size(); ++j) {
                if (!parameters.get(j).isOfType(action.getParameters().get(j).getSpecification())) continue block0;
            }
            return action;
        }
        return null;
    }

    private ObjectAction getAction(List<ObjectAction> availableActions, ActionType type, String id) {
        if (id == null) {
            return null;
        }
        for (int i = 0; i < availableActions.size(); ++i) {
            ObjectAction action = availableActions.get(i);
            if (action.getActions().size() > 0) {
                ObjectAction a = this.getAction(action.getActions(), type, id);
                if (a == null) continue;
                return a;
            }
            if (!type.matchesTypeOf(action)) continue;
            if (id.equals(action.getIdentifier().toNameParmsIdentityString())) {
                return action;
            }
            if (!id.equals(action.getIdentifier().toNameIdentityString())) continue;
            return action;
        }
        return null;
    }

    @Override
    public boolean isCollectionOrIsAggregated() {
        return this.isCollection() || this.isValueOrIsAggregated();
    }

    @Override
    public Object createObject(ObjectSpecification.CreationMode creationMode) {
        return this.createObject(null, creationMode);
    }

    @Override
    public Object createAggregatedObject(ObjectAdapter parent, ObjectSpecification.CreationMode creationMode) {
        return this.createObject(parent, creationMode);
    }

    private Object createObject(ObjectAdapter parent, ObjectSpecification.CreationMode creationMode) {
        if (this.getCorrespondingClass().isArray()) {
            return Array.newInstance(this.getCorrespondingClass().getComponentType(), 0);
        }
        try {
            Object object = this.getObjectInstantiator().instantiate(this.getCorrespondingClass());
            if (creationMode == ObjectSpecification.CreationMode.INITIALIZE) {
                ObjectAdapter adapter = parent == null ? this.getAdapterMap().adapterFor(object) : this.getAdapterMap().adapterForAggregated(object, parent);
                List<ObjectAssociation> fields = adapter.getSpecification().getAssociations();
                for (int i = 0; i < fields.size(); ++i) {
                    fields.get(i).toDefault(adapter);
                }
                this.getDependencyInjector().injectDependenciesInto(object);
                CallbackUtils.callCallback(adapter, CreatedCallbackFacet.class);
            }
            return object;
        }
        catch (ObjectInstantiationException e) {
            throw new IsisException("Failed to create instance of type " + this.getFullIdentifier(), (Throwable)e);
        }
    }

    public ObjectMember getMember(Method method) {
        if (this.membersByMethod == null) {
            HashMap membersByMethod = Maps.newHashMap();
            this.cataloguePropertiesAndCollections(membersByMethod);
            this.catalogueActions(membersByMethod);
            this.membersByMethod = membersByMethod;
        }
        return this.membersByMethod.get(method);
    }

    private void cataloguePropertiesAndCollections(Map<Method, ObjectMember> membersByMethod) {
        Filter noop = Filters.anyOfType(ObjectAssociation.class);
        List<ObjectAssociation> fields = this.getAssociations((Filter<ObjectAssociation>)noop);
        for (int i = 0; i < fields.size(); ++i) {
            ObjectAssociation field = fields.get(i);
            List<Facet> facets = field.getFacets(ImperativeFacet.FILTER);
            for (Facet facet : facets) {
                ImperativeFacet imperativeFacet = ImperativeFacetUtils.getImperativeFacet(facet);
                for (Method imperativeFacetMethod : imperativeFacet.getMethods()) {
                    membersByMethod.put(imperativeFacetMethod, field);
                }
            }
        }
    }

    private void catalogueActions(Map<Method, ObjectMember> membersByMethod) {
        List<ObjectAction> userActions = this.getObjectActions(ActionType.USER, ObjectActionContainer.Contributed.INCLUDED);
        for (int i = 0; i < userActions.size(); ++i) {
            ObjectAction userAction = userActions.get(i);
            List<Facet> facets = userAction.getFacets(ImperativeFacet.FILTER);
            for (Facet facet : facets) {
                ImperativeFacet imperativeFacet = ImperativeFacetUtils.getImperativeFacet(facet);
                for (Method imperativeFacetMethod : imperativeFacet.getMethods()) {
                    membersByMethod.put(imperativeFacetMethod, userAction);
                }
            }
        }
    }

    public void debugData(DebugBuilder debug) {
        debug.blankLine();
        debug.appendln("Title", (Object)this.getFacet(TitleFacet.class));
        IconFacet iconFacet = this.getFacet(IconFacet.class);
        if (iconFacet != null) {
            debug.appendln("Icon", (Object)iconFacet);
        }
        debug.unindent();
    }

    public String debugTitle() {
        return "NO Member Specification";
    }

    @Override
    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("class", this.getFullIdentifier());
        str.append("type", this.isCollection() ? "Collection" : "Object");
        str.append("persistable", (Object)this.persistability());
        str.append("superclass", this.superclass() == null ? "Object" : this.superclass().getFullIdentifier());
        return str.toString();
    }

    protected AdapterMap getAdapterMap() {
        return this.createObjectContext.getAdapterMap();
    }

    protected DependencyInjector getDependencyInjector() {
        return this.createObjectContext.getDependencyInjector();
    }

    private ClassSubstitutor getClassSubstitutor() {
        return this.introspectionContext.getClassSubstitutor();
    }

    private MemberLayoutArranger getMemberLayoutArranger() {
        return this.introspectionContext.getMemberLayoutArranger();
    }
}

