/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.util.List;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebugString;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.object.bounded.BoundedFacetUtils;
import org.apache.isis.core.metamodel.facets.properties.choices.PropertyChoicesFacet;
import org.apache.isis.core.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertyInitializationFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.PropertyAccessContext;
import org.apache.isis.core.metamodel.interactions.PropertyModifyContext;
import org.apache.isis.core.metamodel.interactions.PropertyUsabilityContext;
import org.apache.isis.core.metamodel.interactions.PropertyVisibilityContext;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectAssociationAbstract;

public class OneToOneAssociationImpl
extends ObjectAssociationAbstract
implements OneToOneAssociation {
    public OneToOneAssociationImpl(FacetedMethod facetedMethod, ObjectMemberContext objectMemberContext) {
        super(facetedMethod, FeatureType.PROPERTY, OneToOneAssociationImpl.getSpecification(objectMemberContext.getSpecificationLookup(), facetedMethod.getType()), objectMemberContext);
    }

    @Override
    public VisibilityContext<?> createVisibleInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter ownerAdapter) {
        return new PropertyVisibilityContext(session, invocationMethod, ownerAdapter, this.getIdentifier());
    }

    @Override
    public UsabilityContext<?> createUsableInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter ownerAdapter) {
        return new PropertyUsabilityContext(session, invocationMethod, ownerAdapter, this.getIdentifier());
    }

    @Override
    public ValidityContext<?> createValidateInteractionContext(AuthenticationSession session, InteractionInvocationMethod interactionMethod, ObjectAdapter ownerAdapter, ObjectAdapter proposedToReferenceAdapter) {
        return new PropertyModifyContext(session, interactionMethod, ownerAdapter, this.getIdentifier(), proposedToReferenceAdapter);
    }

    @Override
    public Consent isAssociationValid(ObjectAdapter ownerAdapter, ObjectAdapter proposedToReferenceAdapter) {
        return this.isAssociationValidResult(ownerAdapter, proposedToReferenceAdapter).createConsent();
    }

    private InteractionResult isAssociationValidResult(ObjectAdapter ownerAdapter, ObjectAdapter proposedToReferenceAdapter) {
        ValidityContext<?> validityContext = this.createValidateInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, ownerAdapter, proposedToReferenceAdapter);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    @Override
    public void initAssociation(ObjectAdapter ownerAdapter, ObjectAdapter referencedAdapter) {
        PropertyInitializationFacet initializerFacet = this.getFacet(PropertyInitializationFacet.class);
        if (initializerFacet != null) {
            initializerFacet.initProperty(ownerAdapter, referencedAdapter);
        }
    }

    @Override
    public ObjectAdapter get(ObjectAdapter ownerAdapter) {
        PropertyOrCollectionAccessorFacet facet = this.getFacet(PropertyOrCollectionAccessorFacet.class);
        Object referencedPojo = facet.getProperty(ownerAdapter);
        if (referencedPojo == null) {
            return null;
        }
        return this.getAdapterMap().adapterFor(referencedPojo, ownerAdapter, this);
    }

    @Override
    public PropertyAccessContext createAccessInteractionContext(AuthenticationSession session, InteractionInvocationMethod interactionMethod, ObjectAdapter ownerAdapter) {
        return new PropertyAccessContext(session, InteractionInvocationMethod.BY_USER, ownerAdapter, this.getIdentifier(), this.get(ownerAdapter));
    }

    @Override
    public boolean isEmpty(ObjectAdapter ownerAdapter) {
        return this.get(ownerAdapter) == null;
    }

    @Override
    public void set(ObjectAdapter ownerAdapter, ObjectAdapter newReferencedAdapter) {
        if (newReferencedAdapter != null) {
            this.setValue(ownerAdapter, newReferencedAdapter);
        } else {
            this.clearValue(ownerAdapter);
        }
    }

    @Override
    @Deprecated
    public void setAssociation(ObjectAdapter ownerAdapter, ObjectAdapter newReferencedAdapter) {
        this.setValue(ownerAdapter, newReferencedAdapter);
    }

    private void setValue(ObjectAdapter ownerAdapter, ObjectAdapter newReferencedAdapter) {
        PropertySetterFacet setterFacet = this.getFacet(PropertySetterFacet.class);
        if (setterFacet == null) {
            return;
        }
        if (ownerAdapter.isPersistent() && newReferencedAdapter != null && newReferencedAdapter.isTransient() && !newReferencedAdapter.getSpecification().isAggregated()) {
            throw new IsisException("can't set a reference to a transient object from a persistent one: " + newReferencedAdapter.titleString() + " (transient)");
        }
        setterFacet.setProperty(ownerAdapter, newReferencedAdapter);
    }

    @Override
    @Deprecated
    public void clearAssociation(ObjectAdapter ownerAdapter) {
        this.clearValue(ownerAdapter);
    }

    private void clearValue(ObjectAdapter ownerAdapter) {
        PropertyClearFacet facet = this.getFacet(PropertyClearFacet.class);
        facet.clearProperty(ownerAdapter);
    }

    @Override
    public ObjectAdapter getDefault(ObjectAdapter ownerAdapter) {
        PropertyDefaultFacet propertyDefaultFacet = this.getFacet(PropertyDefaultFacet.class);
        if (propertyDefaultFacet == null || propertyDefaultFacet.isNoop()) {
            propertyDefaultFacet = this.getSpecification().getFacet(PropertyDefaultFacet.class);
        }
        if (propertyDefaultFacet == null) {
            return null;
        }
        return propertyDefaultFacet.getDefault(ownerAdapter);
    }

    @Override
    public void toDefault(ObjectAdapter ownerAdapter) {
        MandatoryFacet mandatoryFacet = this.getFacet(MandatoryFacet.class);
        if (mandatoryFacet != null && mandatoryFacet.isInvertedSemantics()) {
            return;
        }
        ObjectAdapter defaultValue = this.getDefault(ownerAdapter);
        if (defaultValue != null) {
            this.initAssociation(ownerAdapter, defaultValue);
        }
    }

    @Override
    public boolean hasChoices() {
        PropertyChoicesFacet propertyChoicesFacet = this.getFacet(PropertyChoicesFacet.class);
        boolean optionEnabled = propertyChoicesFacet != null;
        return BoundedFacetUtils.isBoundedSet(this.getSpecification()) || optionEnabled;
    }

    @Override
    public ObjectAdapter[] getChoices(ObjectAdapter ownerAdapter) {
        Object[] pojoOptions;
        PropertyChoicesFacet propertyChoicesFacet = this.getFacet(PropertyChoicesFacet.class);
        Object[] objectArray = pojoOptions = propertyChoicesFacet == null ? null : propertyChoicesFacet.getChoices(ownerAdapter, this.getSpecificationLookup());
        if (pojoOptions != null) {
            ObjectAdapter[] options = new ObjectAdapter[pojoOptions.length];
            for (int i = 0; i < options.length; ++i) {
                options[i] = this.getAdapterMap().adapterFor(pojoOptions[i]);
            }
            return options;
        }
        if (BoundedFacetUtils.isBoundedSet(this.getSpecification())) {
            return this.options();
        }
        return null;
    }

    private <T> ObjectAdapter[] options() {
        QueryFindAllInstances query = new QueryFindAllInstances(this.getSpecification().getFullIdentifier());
        List<ObjectAdapter> allInstancesAdapter = this.getQuerySubmitter().allMatchingQuery(query);
        ObjectAdapter[] options = new ObjectAdapter[allInstancesAdapter.size()];
        int j = 0;
        for (ObjectAdapter adapter : allInstancesAdapter) {
            options[j++] = adapter;
        }
        return options;
    }

    @Override
    public Instance getInstance(ObjectAdapter ownerAdapter) {
        OneToOneAssociationImpl specification = this;
        return ownerAdapter.getInstance(specification);
    }

    @Override
    public String debugData() {
        DebugString debugString = new DebugString();
        debugString.indent();
        debugString.indent();
        this.getFacetedMethod().debugData((DebugBuilder)debugString);
        return debugString.toString();
    }

    @Override
    public String toString() {
        ToString str = new ToString((Object)this);
        str.append(super.toString());
        str.setAddComma();
        str.append("persisted", !this.isNotPersisted());
        str.append("type", this.getSpecification().getShortIdentifier());
        return str.toString();
    }
}

