/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ServicesProvider;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolderImpl;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.help.HelpFacet;
import org.apache.isis.core.metamodel.facets.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.object.aggregated.AggregatedFacet;
import org.apache.isis.core.metamodel.facets.object.dirty.ClearDirtyObjectFacet;
import org.apache.isis.core.metamodel.facets.object.dirty.IsDirtyObjectFacet;
import org.apache.isis.core.metamodel.facets.object.dirty.MarkDirtyObjectFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.icon.IconFacet;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.facets.object.notpersistable.InitiatedBy;
import org.apache.isis.core.metamodel.facets.object.notpersistable.NotPersistableFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.object.plural.PluralFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.ObjectTitleContext;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.ObjectActionSet;
import org.apache.isis.core.metamodel.spec.ObjectInstantiator;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecificationException;
import org.apache.isis.core.metamodel.spec.Persistability;
import org.apache.isis.core.metamodel.spec.SpecificationContext;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionContainer;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociationFilters;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.log4j.Logger;

public abstract class ObjectSpecificationAbstract
extends FacetHolderImpl
implements ObjectSpecification {
    private static final Logger LOG = Logger.getLogger(ObjectSpecificationAbstract.class);
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final ServicesProvider servicesProvider;
    private final ObjectInstantiator objectInstantiator;
    private final SpecificationLookup specificationLookup;
    private final List<ObjectAction> objectActions = Lists.newArrayList();
    private final List<ObjectAssociation> associations = Lists.newArrayList();
    private final List<ObjectSpecification> interfaces = Lists.newArrayList();
    private final SubclassList subclasses = new SubclassList();
    private final Map<ActionType, List<ObjectAction>> contributedActionSetsByType = Maps.newLinkedHashMap();
    private final Class<?> correspondingClass;
    private final String fullName;
    private final String shortName;
    private final Identifier identifier;
    private final boolean isAbstract;
    private ObjectSpecification superclassSpec;
    private Persistability persistability = Persistability.USER_PERSISTABLE;
    private MarkDirtyObjectFacet markDirtyObjectFacet;
    private ClearDirtyObjectFacet clearDirtyObjectFacet;
    private IsDirtyObjectFacet isDirtyObjectFacet;
    private TitleFacet titleFacet;
    private IconFacet iconFacet;
    private boolean introspected = false;

    public ObjectSpecificationAbstract(Class<?> introspectedClass, String shortName, SpecificationContext specificationContext) {
        this.correspondingClass = introspectedClass;
        this.fullName = introspectedClass.getName();
        this.shortName = shortName;
        this.isAbstract = JavaClassUtils.isAbstract(introspectedClass);
        this.identifier = Identifier.classIdentifier(introspectedClass);
        this.authenticationSessionProvider = specificationContext.getAuthenticationSessionProvider();
        this.servicesProvider = specificationContext.getServicesProvider();
        this.objectInstantiator = specificationContext.getObjectInstantiator();
        this.specificationLookup = specificationContext.getSpecificationLookup();
    }

    @Override
    public FeatureType getFeatureType() {
        return FeatureType.OBJECT;
    }

    @Override
    public Class<?> getCorrespondingClass() {
        return this.correspondingClass;
    }

    @Override
    public String getShortIdentifier() {
        return this.shortName;
    }

    @Override
    public String getFullIdentifier() {
        return this.fullName;
    }

    @Override
    public boolean isIntrospected() {
        return this.introspected;
    }

    protected void setSuperclass(Class<?> superclass) {
        if (superclass == null) {
            return;
        }
        this.superclassSpec = this.getSpecificationLookup().loadSpecification(superclass);
        if (this.superclassSpec != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("  Superclass " + superclass.getName()));
            }
            this.addAsSubclassTo(this.superclassSpec);
        }
    }

    protected void addInterfaces(List<ObjectSpecification> interfaces) {
        this.interfaces.addAll(interfaces);
    }

    protected void addAsSubclassTo(ObjectSpecification supertypeSpec) {
        if (!(supertypeSpec instanceof ObjectSpecificationAbstract)) {
            return;
        }
        ObjectSpecificationAbstract introspectableSpec = (ObjectSpecificationAbstract)supertypeSpec;
        introspectableSpec.addSubclass(this);
    }

    protected void addAsSubclassTo(List<ObjectSpecification> supertypeSpecs) {
        for (ObjectSpecification supertypeSpec : supertypeSpecs) {
            this.addAsSubclassTo(supertypeSpec);
        }
    }

    private void addSubclass(ObjectSpecification subclass) {
        this.subclasses.addSubclass(subclass);
    }

    protected void addAssociations(List<ObjectAssociation> associations) {
        if (associations == null) {
            return;
        }
        this.associations.addAll(associations);
    }

    protected void addObjectActions(List<ObjectAction> objectActions) {
        if (objectActions == null) {
            return;
        }
        this.objectActions.addAll(objectActions);
    }

    @Override
    public void updateFromFacetValues() {
        Persistability persistability;
        this.clearDirtyObjectFacet = this.getFacet((Class)ClearDirtyObjectFacet.class);
        this.markDirtyObjectFacet = this.getFacet((Class)MarkDirtyObjectFacet.class);
        this.isDirtyObjectFacet = this.getFacet((Class)IsDirtyObjectFacet.class);
        this.titleFacet = this.getFacet((Class)TitleFacet.class);
        this.iconFacet = this.getFacet((Class)IconFacet.class);
        this.persistability = persistability = this.determinePersistability();
    }

    private Persistability determinePersistability() {
        NotPersistableFacet notPersistableFacet = this.getFacet((Class)NotPersistableFacet.class);
        if (notPersistableFacet == null) {
            return Persistability.USER_PERSISTABLE;
        }
        InitiatedBy initiatedBy = notPersistableFacet.value();
        if (initiatedBy == InitiatedBy.USER_OR_PROGRAM) {
            return Persistability.TRANSIENT;
        }
        if (initiatedBy == InitiatedBy.USER) {
            return Persistability.PROGRAM_PERSISTABLE;
        }
        return Persistability.USER_PERSISTABLE;
    }

    protected void setClearDirtyObjectFacet(ClearDirtyObjectFacet clearDirtyObjectFacet) {
        this.clearDirtyObjectFacet = clearDirtyObjectFacet;
    }

    protected void setIntrospected(boolean introspected) {
        this.introspected = introspected;
    }

    @Override
    public String getTitle(ObjectAdapter object, Localization localization) {
        String titleString;
        if (this.titleFacet != null && (titleString = this.titleFacet.title(object, localization)) != null && !titleString.equals("")) {
            return titleString;
        }
        return (this.isService() ? "" : "Untitled ") + this.getSingularName();
    }

    @Override
    public String getIconName(ObjectAdapter reference) {
        return this.iconFacet == null ? null : this.iconFacet.iconName(reference);
    }

    @Override
    public Instance getInstance(ObjectAdapter adapter) {
        return adapter;
    }

    @Override
    public boolean isOfType(ObjectSpecification specification) {
        if (specification == this) {
            return true;
        }
        for (ObjectSpecification interfaceSpec : this.interfaces()) {
            if (!interfaceSpec.isOfType(specification)) continue;
            return true;
        }
        ObjectSpecification superclassSpec = this.superclass();
        return superclassSpec != null ? superclassSpec.isOfType(specification) : false;
    }

    @Override
    public String getSingularName() {
        NamedFacet namedFacet = this.getFacet((Class)NamedFacet.class);
        return namedFacet.value();
    }

    @Override
    public String getPluralName() {
        PluralFacet pluralFacet = this.getFacet((Class)PluralFacet.class);
        return pluralFacet.value();
    }

    @Override
    public String getDescription() {
        DescribedAsFacet describedAsFacet = this.getFacet((Class)DescribedAsFacet.class);
        String describedAs = describedAsFacet.value();
        return describedAs == null ? "" : describedAs;
    }

    @Override
    public String getHelp() {
        HelpFacet helpFacet = this.getFacet((Class)HelpFacet.class);
        return helpFacet == null ? null : helpFacet.value();
    }

    @Override
    public Persistability persistability() {
        return this.persistability;
    }

    @Override
    public boolean isDirty(ObjectAdapter object) {
        return this.isDirtyObjectFacet == null ? false : this.isDirtyObjectFacet.invoke(object);
    }

    @Override
    public void clearDirty(ObjectAdapter object) {
        if (this.clearDirtyObjectFacet != null) {
            this.clearDirtyObjectFacet.invoke(object);
        }
    }

    @Override
    public void markDirty(ObjectAdapter object) {
        if (this.markDirtyObjectFacet != null) {
            this.markDirtyObjectFacet.invoke(object);
        }
    }

    public <Q extends Facet> Q getFacet(Class<Q> facetType) {
        Q superClassFacet;
        ObjectSpecification superSpec;
        Q facet = super.getFacet(facetType);
        Q noopFacet = null;
        if (this.isNotANoopFacet((Facet)facet)) {
            return facet;
        }
        noopFacet = facet;
        if (this.interfaces() != null) {
            List<ObjectSpecification> interfaces = this.interfaces();
            for (int i = 0; i < interfaces.size(); ++i) {
                ObjectSpecification interfaceSpec = interfaces.get(i);
                if (interfaceSpec == null) continue;
                Q interfaceFacet = interfaceSpec.getFacet(facetType);
                if (this.isNotANoopFacet((Facet)interfaceFacet)) {
                    return interfaceFacet;
                }
                if (noopFacet != null) continue;
                noopFacet = interfaceFacet;
            }
        }
        if ((superSpec = this.superclass()) != null && this.isNotANoopFacet((Facet)(superClassFacet = superSpec.getFacet(facetType)))) {
            return superClassFacet;
        }
        return noopFacet;
    }

    private boolean isNotANoopFacet(Facet facet) {
        return facet != null && !facet.isNoop();
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public ObjectTitleContext createTitleInteractionContext(AuthenticationSession session, InteractionInvocationMethod interactionMethod, ObjectAdapter targetObjectAdapter) {
        return new ObjectTitleContext(session, interactionMethod, targetObjectAdapter, this.getIdentifier(), targetObjectAdapter.titleString());
    }

    @Override
    public ObjectSpecification superclass() {
        return this.superclassSpec;
    }

    @Override
    public List<ObjectSpecification> interfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    @Override
    public List<ObjectSpecification> subclasses() {
        return this.subclasses.toList();
    }

    @Override
    public boolean hasSubclasses() {
        return this.subclasses.hasSubclasses();
    }

    @Override
    public final boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public List<ObjectAssociation> getAssociations() {
        return Collections.unmodifiableList(this.associations);
    }

    @Override
    public ObjectAssociation getAssociation(String id) {
        for (ObjectAssociation objectAssociation : this.getAssociations()) {
            if (!objectAssociation.getId().equals(id)) continue;
            return objectAssociation;
        }
        throw new ObjectSpecificationException("No association called '" + id + "' in '" + this.getSingularName() + "'");
    }

    @Override
    public List<ObjectAssociation> getAssociations(Filter<ObjectAssociation> filter) {
        List<ObjectAssociation> allFields = this.getAssociations();
        ArrayList selectedFields = Lists.newArrayList();
        for (int i = 0; i < allFields.size(); ++i) {
            if (!filter.accept((Object)allFields.get(i))) continue;
            selectedFields.add(allFields.get(i));
        }
        return selectedFields;
    }

    @Override
    public List<OneToOneAssociation> getProperties() {
        ArrayList<OneToOneAssociation> list = new ArrayList<OneToOneAssociation>();
        List<ObjectAssociation> associationList = this.getAssociations(ObjectAssociationFilters.PROPERTIES);
        list.addAll(associationList);
        return list;
    }

    @Override
    public List<OneToManyAssociation> getCollections() {
        ArrayList list = Lists.newArrayList();
        List<ObjectAssociation> associationList = this.getAssociations(ObjectAssociationFilters.COLLECTIONS);
        list.addAll(associationList);
        return list;
    }

    @Override
    public List<ObjectAction> getObjectActions(ObjectActionContainer.Contributed contributed) {
        if (contributed.isExcluded()) {
            return Collections.unmodifiableList(this.objectActions);
        }
        return this.getObjectActions(ActionType.ALL_EXCEPT_SET, ObjectActionContainer.Contributed.INCLUDED);
    }

    @Override
    public List<ObjectAction> getObjectActions(List<ActionType> requestedTypes, ObjectActionContainer.Contributed contributed) {
        ArrayList actions = Lists.newArrayList();
        for (ActionType type : requestedTypes) {
            this.addActions(type, actions, contributed);
        }
        return actions;
    }

    @Override
    public List<ObjectAction> getObjectActions(ActionType type, ObjectActionContainer.Contributed contributed) {
        ArrayList actions = Lists.newArrayList();
        return this.addActions(type, actions, contributed);
    }

    private List<ObjectAction> addActions(ActionType type, List<ObjectAction> actionListToAppendTo, ObjectActionContainer.Contributed contributed) {
        if (!this.isService() && contributed.isIncluded()) {
            actionListToAppendTo.addAll(this.getContributedActions(type));
        }
        actionListToAppendTo.addAll(this.getFlattenedActions(this.objectActions, type));
        return actionListToAppendTo;
    }

    private List<ObjectAction> getFlattenedActions(List<ObjectAction> objectActions, ActionType type) {
        ArrayList actions = Lists.newArrayList();
        for (ObjectAction action : objectActions) {
            if (action.getType().isSet()) {
                ObjectActionSet actionSet = (ObjectActionSet)action;
                List<ObjectAction> subActions = actionSet.getActions();
                for (ObjectAction subAction : subActions) {
                    if (!type.matchesTypeOf(subAction)) continue;
                    actions.add(subAction);
                }
                continue;
            }
            if (!type.matchesTypeOf(action)) continue;
            actions.add(action);
        }
        return actions;
    }

    @Override
    public List<ObjectAction> getServiceActionsReturning(ActionType type) {
        return this.getServiceActionsReturning(Collections.singletonList(type));
    }

    @Override
    public List<ObjectAction> getServiceActionsReturning(List<ActionType> types) {
        ArrayList serviceActions = Lists.newArrayList();
        List<ObjectAdapter> services = this.getServicesProvider().getServices();
        for (ObjectAdapter serviceAdapter : services) {
            this.appendServiceActionsReturning(serviceAdapter, types, serviceActions);
        }
        return serviceActions;
    }

    private void appendServiceActionsReturning(ObjectAdapter serviceAdapter, List<ActionType> types, List<ObjectAction> relatedActionsToAppendTo) {
        ArrayList matchingActionsToAppendTo = Lists.newArrayList();
        for (ActionType type : types) {
            List<ObjectAction> serviceActions = serviceAdapter.getSpecification().getObjectActions(type, ObjectActionContainer.Contributed.INCLUDED);
            for (ObjectAction serviceAction : serviceActions) {
                this.addIfReturnsSubtype(serviceAction, matchingActionsToAppendTo);
            }
        }
        if (matchingActionsToAppendTo.size() > 0) {
            ObjectActionSet set = new ObjectActionSet("id", serviceAdapter.titleString(), matchingActionsToAppendTo);
            relatedActionsToAppendTo.add(set);
        }
    }

    private void addIfReturnsSubtype(ObjectAction serviceAction, List<ObjectAction> matchingActionsToAppendTo) {
        ObjectSpecification returnType = serviceAction.getReturnType();
        if (returnType == null) {
            return;
        }
        if (returnType.isCollection()) {
            TypeOfFacet facet = serviceAction.getFacet(TypeOfFacet.class);
            if (facet != null) {
                ObjectSpecification elementType = facet.valueSpec();
                this.addIfReturnsSubtype(serviceAction, elementType, matchingActionsToAppendTo);
            }
        } else {
            this.addIfReturnsSubtype(serviceAction, returnType, matchingActionsToAppendTo);
        }
    }

    private void addIfReturnsSubtype(ObjectAction serviceAction, ObjectSpecification actionType, List<ObjectAction> matchingActionsToAppendTo) {
        if (actionType.isOfType(this)) {
            matchingActionsToAppendTo.add(serviceAction);
        }
    }

    protected List<ObjectAction> getContributedActions(ActionType actionType) {
        if (this.isService()) {
            return Collections.emptyList();
        }
        ArrayList contributedActionSets = this.contributedActionSetsByType.get((Object)actionType);
        if (contributedActionSets == null) {
            contributedActionSets = Lists.newArrayList();
            List<ObjectAdapter> services = this.getServicesProvider().getServices();
            for (ObjectAdapter serviceAdapter : services) {
                this.addContributedActionsIfAny(serviceAdapter, actionType, contributedActionSets);
            }
            this.contributedActionSetsByType.put(actionType, contributedActionSets);
        }
        return contributedActionSets;
    }

    private void addContributedActionsIfAny(ObjectAdapter serviceAdapter, ActionType actionType, List<ObjectAction> contributedActionSetsToAppendTo) {
        ObjectSpecification specification = serviceAdapter.getSpecification();
        if (specification == this) {
            return;
        }
        List<ObjectAction> contributedActions = this.findContributedActions(specification, actionType);
        if (contributedActions.size() == 0) {
            return;
        }
        ObjectActionSet contributedActionSet = new ObjectActionSet("id", serviceAdapter.titleString(), contributedActions);
        contributedActionSetsToAppendTo.add(contributedActionSet);
    }

    private List<ObjectAction> findContributedActions(ObjectSpecification specification, ActionType actionType) {
        ArrayList contributedActions = Lists.newArrayList();
        List<ObjectAction> serviceActions = specification.getObjectActions(actionType, ObjectActionContainer.Contributed.INCLUDED);
        for (ObjectAction serviceAction : serviceActions) {
            if (serviceAction.isAlwaysHidden() || !this.matchesParameterOf(serviceAction)) continue;
            contributedActions.add(serviceAction);
        }
        return contributedActions;
    }

    private boolean matchesParameterOf(ObjectAction serviceAction) {
        List<ObjectActionParameter> params = serviceAction.getParameters();
        for (ObjectActionParameter param : params) {
            if (!this.isOfType(param.getSpecification())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Consent isValid(ObjectAdapter inObject) {
        return this.isValidResult(inObject).createConsent();
    }

    @Override
    public InteractionResult isValidResult(ObjectAdapter targetObjectAdapter) {
        ObjectValidityContext validityContext = this.createValidityInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, targetObjectAdapter);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    @Override
    public ObjectValidityContext createValidityInteractionContext(AuthenticationSession session, InteractionInvocationMethod interactionMethod, ObjectAdapter targetObjectAdapter) {
        return new ObjectValidityContext(session, interactionMethod, targetObjectAdapter, this.getIdentifier());
    }

    @Override
    public boolean isImmutable() {
        return this.containsFacet(ImmutableFacet.class);
    }

    @Override
    public boolean isHidden() {
        return this.containsFacet(HiddenFacet.class);
    }

    @Override
    public boolean isParseable() {
        return this.containsFacet(ParseableFacet.class);
    }

    @Override
    public boolean isEncodeable() {
        return this.containsFacet(EncodableFacet.class);
    }

    @Override
    public boolean isValue() {
        return this.containsFacet(ValueFacet.class);
    }

    @Override
    public boolean isAggregated() {
        return this.containsFacet(AggregatedFacet.class);
    }

    @Override
    public boolean isCollection() {
        return this.containsFacet(CollectionFacet.class);
    }

    @Override
    public boolean isNotCollection() {
        return !this.isCollection();
    }

    @Override
    public boolean isValueOrIsAggregated() {
        return this.isValue() || this.isAggregated();
    }

    @Override
    public boolean isCollectionOrIsAggregated() {
        return false;
    }

    @Override
    public Object createObject(ObjectSpecification.CreationMode creationMode) {
        throw new UnsupportedOperationException(this.getFullIdentifier());
    }

    @Override
    public Object createAggregatedObject(ObjectAdapter parent, ObjectSpecification.CreationMode creationMode) {
        throw new UnsupportedOperationException(this.getFullIdentifier());
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("class", this.getFullIdentifier());
        return str.toString();
    }

    protected final AuthenticationSession getAuthenticationSession() {
        return this.getAuthenticationSessionProvider().getAuthenticationSession();
    }

    protected AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    public ServicesProvider getServicesProvider() {
        return this.servicesProvider;
    }

    public ObjectInstantiator getObjectInstantiator() {
        return this.objectInstantiator;
    }

    public SpecificationLookup getSpecificationLookup() {
        return this.specificationLookup;
    }

    private static class SubclassList {
        private final List<ObjectSpecification> classes = Lists.newArrayList();

        private SubclassList() {
        }

        public void addSubclass(ObjectSpecification subclass) {
            this.classes.add(subclass);
        }

        public boolean hasSubclasses() {
            return !this.classes.isEmpty();
        }

        public List<ObjectSpecification> toList() {
            return Collections.unmodifiableList(this.classes);
        }
    }
}

