/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import org.apache.isis.core.metamodel.adapter.MutableProposedHolder;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.TypedHolder;
import org.apache.isis.core.metamodel.facets.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.multiline.MultiLineFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.interactions.ActionArgumentContext;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ParseableEntryActionParameter;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterAbstract;

public class ObjectActionParameterParseable
extends ObjectActionParameterAbstract
implements ParseableEntryActionParameter {
    public ObjectActionParameterParseable(int index, ObjectActionImpl action, TypedHolder peer) {
        super(index, action, peer);
    }

    @Override
    public int getNoLines() {
        MultiLineFacet facet = this.getFacet(MultiLineFacet.class);
        return facet.numberOfLines();
    }

    @Override
    public boolean canWrap() {
        MultiLineFacet facet = this.getFacet(MultiLineFacet.class);
        return !facet.preventWrapping();
    }

    @Override
    public int getMaximumLength() {
        MaxLengthFacet facet = this.getFacet(MaxLengthFacet.class);
        return facet.value();
    }

    @Override
    public int getTypicalLineLength() {
        TypicalLengthFacet facet = this.getFacet(TypicalLengthFacet.class);
        return facet.value();
    }

    @Override
    public String isValid(ObjectAdapter adapter, Object proposedValue) {
        if (!(proposedValue instanceof String)) {
            return null;
        }
        String proposedString = (String)proposedValue;
        ObjectActionParameter objectActionParameter = this.getAction().getParameters().get(this.getNumber());
        if (!(objectActionParameter instanceof ParseableEntryActionParameter)) {
            return null;
        }
        ParseableEntryActionParameter parameter = (ParseableEntryActionParameter)objectActionParameter;
        ObjectSpecification parameterSpecification = parameter.getSpecification();
        ParseableFacet p = parameterSpecification.getFacet(ParseableFacet.class);
        ObjectAdapter newValue = p.parseTextEntry(null, proposedString);
        ActionArgumentContext ic = parameter.createProposedArgumentInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, adapter, this.arguments(newValue), this.getNumber());
        InteractionResultSet buf = new InteractionResultSet();
        InteractionUtils.isValidResultSet(parameter, ic, buf);
        if (buf.isVetoed()) {
            return buf.getInteractionResult().getReason();
        }
        return null;
    }

    private ObjectAdapter[] arguments(ObjectAdapter proposedValue) {
        int parameterCount = this.getAction().getParameterCount();
        ObjectAdapter[] arguments = new ObjectAdapter[parameterCount];
        arguments[this.getNumber()] = proposedValue;
        return arguments;
    }

    @Override
    public Instance getInstance(ObjectAdapter adapter) {
        ObjectActionParameterParseable specification = this;
        return adapter.getInstance(specification);
    }

    @Override
    public ObjectAdapter get(ObjectAdapter owner) {
        MutableProposedHolder proposedHolder = this.getProposedHolder(owner);
        Object proposed = proposedHolder.getProposed();
        return this.getAdapterMap().adapterFor(proposed);
    }

    public void set(ObjectAdapter owner, ObjectAdapter newValue) {
        MutableProposedHolder proposedHolder = this.getProposedHolder(owner);
        Object newValuePojo = newValue.getObject();
        proposedHolder.setProposed(newValuePojo);
    }

    private MutableProposedHolder getProposedHolder(ObjectAdapter owner) {
        Instance instance = this.getInstance(owner);
        if (!(instance instanceof MutableProposedHolder)) {
            throw new IllegalArgumentException("Instance should implement MutableProposedHolder");
        }
        MutableProposedHolder proposedHolder = (MutableProposedHolder)((Object)instance);
        return proposedHolder;
    }

    @Override
    public FeatureType getFeatureType() {
        return FeatureType.ACTION_PARAMETER;
    }
}

