/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.QuerySubmitter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.consent.Allow;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.TypedHolder;
import org.apache.isis.core.metamodel.facets.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.object.bounded.BoundedFacetUtils;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.ActionParameterDefaultsFacet;
import org.apache.isis.core.metamodel.interactions.ActionArgumentContext;
import org.apache.isis.core.metamodel.spec.DomainModelException;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectMemberAbstract;

public abstract class ObjectActionParameterAbstract
implements ObjectActionParameter {
    private final int number;
    private final ObjectActionImpl parentAction;
    private final TypedHolder peer;

    protected ObjectActionParameterAbstract(int number, ObjectActionImpl objectAction, TypedHolder peer) {
        this.number = number;
        this.parentAction = objectAction;
        this.peer = peer;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public ObjectAction getAction() {
        return this.parentAction;
    }

    @Override
    public ObjectSpecification getSpecification() {
        return ObjectMemberAbstract.getSpecification(this.getSpecificationLookup(), this.peer.getType());
    }

    @Override
    public Identifier getIdentifier() {
        return this.parentAction.getIdentifier();
    }

    @Override
    public String getId() {
        NamedFacet facet = this.getFacet(NamedFacet.class);
        if (facet != null && facet.value() != null) {
            return StringUtils.camelLowerFirst((String)facet.value());
        }
        String name = this.getSpecification().getSingularName();
        List<ObjectActionParameter> parameters = this.getAction().getParameters(new Filter<ObjectActionParameter>(){

            public boolean accept(ObjectActionParameter t) {
                return this.equalsShortIdentifier(t.getSpecification(), ObjectActionParameterAbstract.this.getSpecification());
            }

            protected boolean equalsShortIdentifier(ObjectSpecification spec1, ObjectSpecification spec2) {
                return spec1.getShortIdentifier().toLowerCase().equals(spec2.getShortIdentifier().toLowerCase());
            }
        });
        if (parameters.size() == 1) {
            return StringUtils.camelLowerFirst((String)name);
        }
        int indexOf = parameters.indexOf(this);
        return StringUtils.camelLowerFirst((String)(name + (indexOf + 1)));
    }

    @Override
    public String getName() {
        NamedFacet facet = this.getFacet(NamedFacet.class);
        if (facet != null && facet.value() != null) {
            return facet.value();
        }
        String name = this.getSpecification().getSingularName();
        List<ObjectActionParameter> parameters = this.getAction().getParameters(new Filter<ObjectActionParameter>(){

            public boolean accept(ObjectActionParameter t) {
                return this.equalsShortIdentifier(t.getSpecification(), ObjectActionParameterAbstract.this.getSpecification());
            }

            protected boolean equalsShortIdentifier(ObjectSpecification spec1, ObjectSpecification spec2) {
                return spec1.getShortIdentifier().toLowerCase().equals(spec2.getShortIdentifier().toLowerCase());
            }
        });
        if (parameters.size() == 1) {
            return name;
        }
        int indexOf = parameters.indexOf(this);
        return name + " " + (indexOf + 1);
    }

    @Override
    public String getDescription() {
        DescribedAsFacet facet = this.getFacet(DescribedAsFacet.class);
        String description = facet.value();
        return description == null ? "" : description;
    }

    @Override
    public boolean isOptional() {
        MandatoryFacet facet = this.getFacet(MandatoryFacet.class);
        return facet.isInvertedSemantics();
    }

    public Consent isUsable() {
        return Allow.DEFAULT;
    }

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.peer != null ? this.peer.containsFacet(facetType) : false;
    }

    @Override
    public boolean containsDoOpFacet(Class<? extends Facet> facetType) {
        return this.peer == null ? false : this.peer.containsDoOpFacet(facetType);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> cls) {
        return this.peer != null ? (T)this.peer.getFacet(cls) : null;
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return this.peer != null ? this.peer.getFacetTypes() : new Class[]{};
    }

    @Override
    public List<Facet> getFacets(Filter<Facet> filter) {
        return this.peer != null ? this.peer.getFacets(filter) : Lists.newArrayList();
    }

    @Override
    public void addFacet(Facet facet) {
        if (this.peer != null) {
            this.peer.addFacet(facet);
        }
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        if (this.peer != null) {
            this.peer.addFacet(facet);
        }
    }

    @Override
    public void removeFacet(Facet facet) {
        if (this.peer != null) {
            this.peer.removeFacet(facet);
        }
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        if (this.peer != null) {
            this.peer.removeFacet(facetType);
        }
    }

    @Override
    public ActionArgumentContext createProposedArgumentInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter targetObject, ObjectAdapter[] proposedArguments, int position) {
        return new ActionArgumentContext(this.getAuthenticationSession(), invocationMethod, targetObject, this.getIdentifier(), proposedArguments, position);
    }

    @Override
    public ObjectAdapter[] getChoices(ObjectAdapter adapter) {
        ArrayList parameterChoices = Lists.newArrayList();
        ActionParameterChoicesFacet choicesFacet = this.getFacet(ActionParameterChoicesFacet.class);
        if (choicesFacet != null) {
            Object[] choices = choicesFacet.getChoices(this.parentAction.realTarget(adapter));
            ObjectActionParameterAbstract.checkChoicesType(this.getSpecificationLookup(), choices, this.getSpecification());
            for (Object choice : choices) {
                parameterChoices.add(this.getAdapterMap().adapterFor(choice));
            }
        }
        if (parameterChoices.size() == 0 && BoundedFacetUtils.isBoundedSet(this.getSpecification())) {
            this.addParameterChoicesForBounded(parameterChoices);
        }
        return parameterChoices.toArray(new ObjectAdapter[0]);
    }

    private <T> void addParameterChoicesForBounded(List<ObjectAdapter> parameterChoices) {
        QueryFindAllInstances query = new QueryFindAllInstances(this.getSpecification().getFullIdentifier());
        List<ObjectAdapter> allInstancesAdapter = this.getQuerySubmitter().allMatchingQuery(query);
        for (ObjectAdapter choiceAdapter : allInstancesAdapter) {
            parameterChoices.add(choiceAdapter);
        }
    }

    protected static void checkChoicesType(SpecificationLookup specificationLookup, Object[] objects, ObjectSpecification paramSpec) {
        for (Object object : objects) {
            ObjectSpecification componentSpec = specificationLookup.loadSpecification(object.getClass());
            if (componentSpec.isOfType(paramSpec)) continue;
            throw new DomainModelException("Choice type incompatible with parameter type; expected " + paramSpec.getFullIdentifier() + ", but was " + componentSpec.getFullIdentifier());
        }
    }

    @Override
    public ObjectAdapter getDefault(ObjectAdapter adapter) {
        if (this.parentAction.isContributed() && adapter != null && adapter.getSpecification().isOfType(this.getSpecification())) {
            return adapter;
        }
        ActionParameterDefaultsFacet defaultsFacet = this.getFacet(ActionParameterDefaultsFacet.class);
        if (defaultsFacet != null) {
            Object dflt = defaultsFacet.getDefault(this.parentAction.realTarget(adapter));
            if (dflt == null) {
                return null;
            }
            return this.getAdapterMap().adapterFor(dflt);
        }
        return null;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getAuthenticationSessionProvider().getAuthenticationSession();
    }

    protected SpecificationLookup getSpecificationLookup() {
        return this.parentAction.getSpecificationLookup();
    }

    protected AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.parentAction.getAuthenticationSessionProvider();
    }

    protected AdapterMap getAdapterMap() {
        return this.parentAction.getAdapterMap();
    }

    protected QuerySubmitter getQuerySubmitter() {
        return this.parentAction.getQuerySubmitter();
    }
}

