/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ListUtils;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.facets.FacetsFacet;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.methodutils.MethodFinderUtils;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.facetprocessor.FacetProcessor;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilderContext;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectSpecificationAbstract;
import org.apache.isis.core.metamodel.specloader.traverser.SpecificationTraverser;
import org.apache.log4j.Logger;

public class FacetedMethodsBuilder {
    private static final Logger LOG = Logger.getLogger(FacetedMethodsBuilder.class);
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private final FacetHolder spec;
    private final Class<?> introspectedClass;
    private final List<Method> methods;
    private List<FacetedMethod> associationFacetMethods;
    private List<FacetedMethod> actionFacetedMethods;
    private final FacetedMethodsMethodRemover methodRemover;
    private final FacetProcessor facetProcessor;
    private final SpecificationTraverser specificationTraverser;
    private final ClassSubstitutor classSubstitutor;
    private final SpecificationLoader specificationLoader;

    public FacetedMethodsBuilder(ObjectSpecificationAbstract spec, FacetedMethodsBuilderContext facetedMethodsBuilderContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating JavaIntrospector for " + spec.getFullIdentifier()));
        }
        this.spec = spec;
        this.introspectedClass = spec.getCorrespondingClass();
        this.methods = Arrays.asList(this.introspectedClass.getMethods());
        this.methodRemover = new FacetedMethodsMethodRemover(this.methods);
        this.facetProcessor = facetedMethodsBuilderContext.facetProcessor;
        this.specificationTraverser = facetedMethodsBuilderContext.specificationTraverser;
        this.classSubstitutor = facetedMethodsBuilderContext.classSubstitutor;
        this.specificationLoader = facetedMethodsBuilderContext.specificationLoader;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("finalizing inspector " + this));
        }
    }

    private String getClassName() {
        return this.introspectedClass.getName();
    }

    public void introspectClass() {
        LOG.info((Object)("introspecting " + this.getClassName()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("introspecting " + this.getClassName() + ": class-level details"));
        }
        this.getFacetProcessor().process(this.introspectedClass, this.methodRemover, this.spec);
        FacetsFacet facetsFacet = this.spec.getFacet(FacetsFacet.class);
        if (facetsFacet != null) {
            Class<? extends FacetFactory>[] facetFactories;
            for (Class<? extends FacetFactory> facetFactorie : facetFactories = facetsFacet.facetFactories()) {
                FacetFactory facetFactory = null;
                try {
                    facetFactory = facetFactorie.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IsisException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new IsisException((Throwable)e);
                }
                this.getFacetProcessor().injectDependenciesInto(facetFactory);
                facetFactory.process(new FacetFactory.ProcessClassContext(this.introspectedClass, this.methodRemover, this.spec));
            }
        }
    }

    public List<FacetedMethod> getAssociationFacetedMethods() {
        if (this.associationFacetMethods == null) {
            this.associationFacetMethods = this.createAssociationFacetedMethods();
        }
        return this.associationFacetMethods;
    }

    private List<FacetedMethod> createAssociationFacetedMethods() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("introspecting " + this.getClassName() + ": properties and collections"));
        }
        Set<Method> associationCandidateMethods = this.getFacetProcessor().findAssociationCandidateAccessors(this.methods, new HashSet<Method>());
        ArrayList typesToLoad = Lists.newArrayList();
        for (Method method : associationCandidateMethods) {
            this.getSpecificationTraverser().traverseTypes(method, typesToLoad);
        }
        this.getSpecificationLoader().loadSpecifications(typesToLoad, this.introspectedClass);
        ArrayList associationFacetedMethods = Lists.newArrayList();
        this.findAndRemoveCollectionAccessorsAndCreateCorrespondingFacetedMethods(associationFacetedMethods);
        this.findAndRemovePropertyAccessorsAndCreateCorrespondingFacetedMethods(associationFacetedMethods);
        return Collections.unmodifiableList(associationFacetedMethods);
    }

    private void findAndRemoveCollectionAccessorsAndCreateCorrespondingFacetedMethods(List<FacetedMethod> associationPeers) {
        ArrayList collectionAccessors = Lists.newArrayList();
        this.getFacetProcessor().findAndRemoveCollectionAccessors(this.methodRemover, collectionAccessors);
        this.createCollectionFacetedMethodsFromAccessors(collectionAccessors, associationPeers);
    }

    private void findAndRemovePropertyAccessorsAndCreateCorrespondingFacetedMethods(List<FacetedMethod> fields) {
        ArrayList propertyAccessors = Lists.newArrayList();
        this.getFacetProcessor().findAndRemovePropertyAccessors(this.methodRemover, propertyAccessors);
        this.findAndRemovePrefixedNonVoidMethods(MethodScope.OBJECT, GET_PREFIX, Object.class, 0, propertyAccessors);
        this.findAndRemovePrefixedNonVoidMethods(MethodScope.OBJECT, IS_PREFIX, Boolean.class, 0, propertyAccessors);
        this.createPropertyFacetedMethodsFromAccessors(propertyAccessors, fields);
    }

    private void createCollectionFacetedMethodsFromAccessors(List<Method> accessorMethods, List<FacetedMethod> facetMethodsToAppendto) {
        for (Method accessorMethod : accessorMethods) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("  identified accessor method representing collection: " + accessorMethod));
            }
            FacetedMethod facetedMethod = FacetedMethod.createCollectionFacetedMethod(this.introspectedClass, accessorMethod);
            this.getFacetProcessor().process(this.introspectedClass, accessorMethod, this.methodRemover, facetedMethod, FeatureType.COLLECTION);
            Class elementType = Object.class;
            TypeOfFacet typeOfFacet = facetedMethod.getFacet(TypeOfFacet.class);
            if (typeOfFacet != null) {
                elementType = typeOfFacet.value();
            }
            facetedMethod.setType(elementType);
            if (this.getClassSubstitutor().getClass(elementType) == null) continue;
            facetMethodsToAppendto.add(facetedMethod);
        }
    }

    private void createPropertyFacetedMethodsFromAccessors(List<Method> accessorMethods, List<FacetedMethod> facetedMethodsToAppendto) throws MetaModelException {
        for (Method accessorMethod : accessorMethods) {
            LOG.debug((Object)("  identified accessor method representing property: " + accessorMethod));
            Class<?> returnType = accessorMethod.getReturnType();
            if (this.getClassSubstitutor().getClass(returnType) == null) continue;
            FacetedMethod facetedMethod = FacetedMethod.createPropertyFacetedMethod(this.introspectedClass, accessorMethod);
            this.getFacetProcessor().process(this.introspectedClass, accessorMethod, this.methodRemover, facetedMethod, FeatureType.PROPERTY);
            facetedMethodsToAppendto.add(facetedMethod);
        }
    }

    public List<FacetedMethod> getActionFacetedMethods() {
        if (this.actionFacetedMethods == null) {
            this.actionFacetedMethods = this.findActionFacetedMethods(MethodScope.OBJECT);
        }
        return this.actionFacetedMethods;
    }

    private List<FacetedMethod> findActionFacetedMethods(MethodScope methodScope) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("introspecting " + this.getClassName() + ": actions"));
        }
        List<FacetedMethod> actionFacetedMethods1 = this.findActionFacetedMethods(methodScope, RecognisedHelpersStrategy.SKIP);
        List<FacetedMethod> actionFacetedMethods2 = this.findActionFacetedMethods(methodScope, RecognisedHelpersStrategy.DONT_SKIP);
        return ListUtils.combine(actionFacetedMethods1, actionFacetedMethods2);
    }

    private List<FacetedMethod> findActionFacetedMethods(MethodScope methodScope, RecognisedHelpersStrategy recognisedHelpersStrategy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"  looking for action methods");
        }
        ArrayList actionFacetedMethods = Lists.newArrayList();
        for (int i = 0; i < this.methods.size(); ++i) {
            FacetedMethod actionPeer;
            Method method = this.methods.get(i);
            if (method == null || (actionPeer = this.findActionMethodPeer(methodScope, recognisedHelpersStrategy, method)) == null) continue;
            this.methods.set(i, null);
            actionFacetedMethods.add(actionPeer);
        }
        return actionFacetedMethods;
    }

    private FacetedMethod findActionMethodPeer(MethodScope methodScope, RecognisedHelpersStrategy recognisedHelpersStrategy, Method actionMethod) {
        if (!this.representsAction(actionMethod, methodScope, recognisedHelpersStrategy)) {
            return null;
        }
        return this.createActionFacetedMethod(actionMethod);
    }

    private FacetedMethod createActionFacetedMethod(Method actionMethod) {
        if (!this.isAllParamTypesValid(actionMethod)) {
            return null;
        }
        FacetedMethod action = FacetedMethod.createActionFacetedMethod(this.introspectedClass, actionMethod);
        this.getFacetProcessor().process(this.introspectedClass, actionMethod, this.methodRemover, action, FeatureType.ACTION);
        List<FacetedMethodParameter> actionParams = action.getParameters();
        for (int j = 0; j < actionParams.size(); ++j) {
            this.getFacetProcessor().processParams(actionMethod, j, actionParams.get(j));
        }
        return action;
    }

    private boolean isAllParamTypesValid(Method actionMethod) {
        for (Class<?> paramType : actionMethod.getParameterTypes()) {
            ObjectSpecification paramSpec = this.getSpecificationLoader().loadSpecification(paramType);
            if (paramSpec != null) continue;
            return false;
        }
        return true;
    }

    private boolean representsAction(Method actionMethod, MethodScope methodScope, RecognisedHelpersStrategy recognisedHelpersStrategy) {
        if (!MethodFinderUtils.inScope(methodScope, actionMethod)) {
            return false;
        }
        ArrayList typesToLoad = new ArrayList();
        this.getSpecificationTraverser().traverseTypes(actionMethod, typesToLoad);
        boolean anyLoadedAsNull = this.getSpecificationLoader().loadSpecifications(typesToLoad);
        if (anyLoadedAsNull) {
            return false;
        }
        if (!this.loadParamSpecs(actionMethod)) {
            return false;
        }
        if (this.getFacetProcessor().recognizes(actionMethod)) {
            if (actionMethod.getName().startsWith("set")) {
                return false;
            }
            if (recognisedHelpersStrategy.skip()) {
                LOG.info((Object)("  skipping possible helper method " + actionMethod));
                return false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("  identified action " + actionMethod));
        }
        return true;
    }

    private boolean loadParamSpecs(Method actionMethod) {
        Class<?>[] parameterTypes = actionMethod.getParameterTypes();
        return this.loadParamSpecs(parameterTypes);
    }

    private boolean loadParamSpecs(Class<?>[] parameterTypes) {
        int numParameters = parameterTypes.length;
        for (int j = 0; j < numParameters; ++j) {
            ObjectSpecification paramSpec = this.getSpecificationLoader().loadSpecification(parameterTypes[j]);
            if (paramSpec != null) continue;
            return false;
        }
        return true;
    }

    private void findAndRemovePrefixedNonVoidMethods(MethodScope methodScope, String prefix, Class<?> returnType, int paramCount, List<Method> methodListToAppendTo) {
        List<Method> matchingMethods = this.findAndRemovePrefixedMethods(methodScope, prefix, returnType, false, paramCount);
        methodListToAppendTo.addAll(matchingMethods);
    }

    private List<Method> findAndRemovePrefixedMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
        return MethodFinderUtils.removeMethods(this.methods, methodScope, prefix, returnType, canBeVoid, paramCount);
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("class", this.getClassName());
        return str.toString();
    }

    private SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    private SpecificationTraverser getSpecificationTraverser() {
        return this.specificationTraverser;
    }

    private FacetProcessor getFacetProcessor() {
        return this.facetProcessor;
    }

    private ClassSubstitutor getClassSubstitutor() {
        return this.classSubstitutor;
    }

    private static enum RecognisedHelpersStrategy {
        SKIP,
        DONT_SKIP;


        public boolean skip() {
            return this == SKIP;
        }
    }

    private static final class FacetedMethodsMethodRemover
    implements MethodRemover {
        private final List<Method> methods;

        private FacetedMethodsMethodRemover(List<Method> methods) {
            this.methods = methods;
        }

        @Override
        public void removeMethod(MethodScope methodScope, String methodName, Class<?> returnType, Class<?>[] parameterTypes) {
            MethodFinderUtils.removeMethod(this.methods, methodScope, methodName, returnType, parameterTypes);
        }

        @Override
        public List<Method> removeMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
            return MethodFinderUtils.removeMethods(this.methods, methodScope, prefix, returnType, canBeVoid, paramCount);
        }

        @Override
        public void removeMethod(Method method) {
            if (method == null) {
                return;
            }
            for (int i = 0; i < this.methods.size(); ++i) {
                if (this.methods.get(i) == null || !this.methods.get(i).equals(method)) continue;
                this.methods.set(i, null);
            }
        }

        @Override
        public void removeMethods(List<Method> methodsToRemove) {
            block0: for (int i = 0; i < this.methods.size(); ++i) {
                if (this.methods.get(i) == null) continue;
                for (Method method : methodsToRemove) {
                    if (!this.methods.get(i).equals(method)) continue;
                    this.methods.set(i, null);
                    continue block0;
                }
            }
        }
    }
}

