/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.speccache;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.speccache.SpecificationCache;

public class SpecificationCacheDefault
implements SpecificationCache {
    private final Map<String, ObjectSpecification> specByClassName = Maps.newHashMap();

    @Override
    public ObjectSpecification get(String className) {
        return this.specByClassName.get(className);
    }

    @Override
    public void cache(String className, ObjectSpecification spec) {
        this.specByClassName.put(className, spec);
    }

    @Override
    public void clear() {
        this.specByClassName.clear();
    }

    @Override
    public Collection<ObjectSpecification> allSpecifications() {
        return Collections.unmodifiableCollection(this.specByClassName.values());
    }
}

