/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.facetprocessor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.lang.ListUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.MethodFilteringFacetFactory;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactory;
import org.apache.isis.core.metamodel.facets.MethodRemoverConstants;
import org.apache.isis.core.metamodel.facets.PropertyOrCollectionIdentifyingFacetFactory;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContextAware;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class FacetProcessor
implements RuntimeContextAware {
    private final IsisConfiguration configuration;
    private final CollectionTypeRegistry collectionTypeRegistry;
    private final ProgrammingModel programmingModel;
    private RuntimeContext runtimeContext;
    private final Map<Class<? extends FacetFactory>, FacetFactory> factoryByFactoryType = Maps.newHashMap();
    private final List<FacetFactory> factories = Lists.newArrayList();
    private List<String> cachedMethodPrefixes;
    private List<MethodFilteringFacetFactory> cachedMethodFilteringFactories;
    private List<PropertyOrCollectionIdentifyingFacetFactory> cachedPropertyOrCollectionIdentifyingFactories;
    private Map<FeatureType, List<FacetFactory>> factoryListByFeatureType = null;

    public FacetProcessor(IsisConfiguration configuration, CollectionTypeRegistry collectionTypeRegistry, ProgrammingModel programmingModel) {
        Ensure.ensureThatState((Object)configuration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState((Object)collectionTypeRegistry, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState((Object)programmingModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.configuration = configuration;
        this.programmingModel = programmingModel;
        this.collectionTypeRegistry = collectionTypeRegistry;
    }

    public void init() {
        Ensure.ensureThatState((Object)this.runtimeContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.programmingModel.init();
        List<FacetFactory> facetFactoryList = this.programmingModel.getList();
        for (FacetFactory facetFactory : facetFactoryList) {
            this.registerFactory(facetFactory);
        }
    }

    public void shutdown() {
    }

    public void registerFactory(FacetFactory factory) {
        this.clearCaches();
        this.factoryByFactoryType.put(factory.getClass(), factory);
        this.factories.add(factory);
        this.injectDependenciesInto(factory);
    }

    public void injectDependenciesInto(FacetFactory factory) {
        this.getCollectionTypeRepository().injectInto(factory);
        this.getIsisConfiguration().injectInto((Object)factory);
        this.getRuntimeContext().injectInto(factory);
    }

    public FacetFactory getFactoryByFactoryType(Class<? extends FacetFactory> factoryType) {
        return this.factoryByFactoryType.get(factoryType);
    }

    public Set<Method> findAssociationCandidateAccessors(List<Method> methods, Set<Method> candidates) {
        this.cachePropertyOrCollectionIdentifyingFacetFactoriesIfRequired();
        for (Method method : methods) {
            if (method == null) continue;
            for (PropertyOrCollectionIdentifyingFacetFactory facetFactory : this.cachedPropertyOrCollectionIdentifyingFactories) {
                if (!facetFactory.isPropertyOrCollectionAccessorCandidate(method)) continue;
                candidates.add(method);
            }
        }
        return candidates;
    }

    public void findAndRemovePropertyAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        this.cachePropertyOrCollectionIdentifyingFacetFactoriesIfRequired();
        for (PropertyOrCollectionIdentifyingFacetFactory facetFactory : this.cachedPropertyOrCollectionIdentifyingFactories) {
            facetFactory.findAndRemovePropertyAccessors(methodRemover, methodListToAppendTo);
        }
    }

    public void findAndRemoveCollectionAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        this.cachePropertyOrCollectionIdentifyingFacetFactoriesIfRequired();
        for (PropertyOrCollectionIdentifyingFacetFactory facetFactory : this.cachedPropertyOrCollectionIdentifyingFactories) {
            facetFactory.findAndRemoveCollectionAccessors(methodRemover, methodListToAppendTo);
        }
    }

    public boolean recognizes(Method method) {
        this.cacheMethodPrefixesIfRequired();
        String methodName = method.getName();
        for (String prefix : this.cachedMethodPrefixes) {
            if (!methodName.startsWith(prefix)) continue;
            return true;
        }
        this.cacheMethodFilteringFacetFactoriesIfRequired();
        for (MethodFilteringFacetFactory factory : this.cachedMethodFilteringFactories) {
            if (!factory.recognizes(method)) continue;
            return true;
        }
        return false;
    }

    public void process(Class<?> cls, MethodRemover methodRemover, FacetHolder facetHolder) {
        List<FacetFactory> factoryList = this.getFactoryListByFeatureType(FeatureType.OBJECT);
        for (FacetFactory facetFactory : factoryList) {
            facetFactory.process(new FacetFactory.ProcessClassContext(cls, this.removerElseNullRemover(methodRemover), facetHolder));
        }
    }

    public void process(Class<?> cls, Method method, MethodRemover methodRemover, FacetedMethod facetedMethod, FeatureType featureType) {
        List<FacetFactory> factoryList = this.getFactoryListByFeatureType(featureType);
        for (FacetFactory facetFactory : factoryList) {
            facetFactory.process(new FacetFactory.ProcessMethodContext(cls, method, this.removerElseNullRemover(methodRemover), facetedMethod));
        }
    }

    public void processParams(Method method, int paramNum, FacetedMethodParameter facetedMethodParameter) {
        List<FacetFactory> factoryList = this.getFactoryListByFeatureType(FeatureType.ACTION_PARAMETER);
        for (FacetFactory facetFactory : factoryList) {
            facetFactory.processParams(new FacetFactory.ProcessParameterContext(method, paramNum, facetedMethodParameter));
        }
    }

    private List<FacetFactory> getFactoryListByFeatureType(FeatureType featureType) {
        this.cacheByFeatureTypeIfRequired();
        return this.factoryListByFeatureType.get((Object)featureType);
    }

    private void clearCaches() {
        this.factoryListByFeatureType = null;
        this.cachedMethodPrefixes = null;
        this.cachedMethodFilteringFactories = null;
        this.cachedPropertyOrCollectionIdentifyingFactories = null;
    }

    private synchronized void cacheByFeatureTypeIfRequired() {
        if (this.factoryListByFeatureType != null) {
            return;
        }
        this.factoryListByFeatureType = Maps.newHashMap();
        for (FacetFactory factory : this.factories) {
            List<FeatureType> featureTypes = factory.getFeatureTypes();
            for (FeatureType featureType : featureTypes) {
                List<FacetFactory> factoryList = FacetProcessor.getList(this.factoryListByFeatureType, featureType);
                factoryList.add(factory);
            }
        }
    }

    private synchronized void cacheMethodPrefixesIfRequired() {
        if (this.cachedMethodPrefixes != null) {
            return;
        }
        this.cachedMethodPrefixes = Lists.newArrayList();
        for (FacetFactory facetFactory : this.factories) {
            if (!(facetFactory instanceof MethodPrefixBasedFacetFactory)) continue;
            MethodPrefixBasedFacetFactory methodPrefixBasedFacetFactory = (MethodPrefixBasedFacetFactory)facetFactory;
            ListUtils.merge(this.cachedMethodPrefixes, methodPrefixBasedFacetFactory.getPrefixes());
        }
    }

    private synchronized void cacheMethodFilteringFacetFactoriesIfRequired() {
        if (this.cachedMethodFilteringFactories != null) {
            return;
        }
        this.cachedMethodFilteringFactories = Lists.newArrayList();
        for (FacetFactory factory : this.factories) {
            if (!(factory instanceof MethodFilteringFacetFactory)) continue;
            MethodFilteringFacetFactory methodFilteringFacetFactory = (MethodFilteringFacetFactory)factory;
            this.cachedMethodFilteringFactories.add(methodFilteringFacetFactory);
        }
    }

    private synchronized void cachePropertyOrCollectionIdentifyingFacetFactoriesIfRequired() {
        if (this.cachedPropertyOrCollectionIdentifyingFactories != null) {
            return;
        }
        this.cachedPropertyOrCollectionIdentifyingFactories = Lists.newArrayList();
        for (FacetFactory factory : this.factories) {
            if (!(factory instanceof PropertyOrCollectionIdentifyingFacetFactory)) continue;
            PropertyOrCollectionIdentifyingFacetFactory identifyingFacetFactory = (PropertyOrCollectionIdentifyingFacetFactory)factory;
            this.cachedPropertyOrCollectionIdentifyingFactories.add(identifyingFacetFactory);
        }
    }

    private static <K, T> List<T> getList(Map<K, List<T>> map, K key) {
        ArrayList list = map.get(key);
        if (list == null) {
            list = Lists.newArrayList();
            map.put(key, list);
        }
        return list;
    }

    private MethodRemover removerElseNullRemover(MethodRemover methodRemover) {
        return methodRemover != null ? methodRemover : MethodRemoverConstants.NULL;
    }

    private IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    private CollectionTypeRegistry getCollectionTypeRepository() {
        return this.collectionTypeRegistry;
    }

    private RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }
}

