/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.collectiontyperegistry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.metamodel.spec.feature.OneToManyFeature;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryAbstract;

public class CollectionTypeRegistryDefault
extends CollectionTypeRegistryAbstract {
    private final List<Class<?>> collectionTypes = new ArrayList();
    private Class<?>[] collectionTypesAsArray = new Class[0];

    public CollectionTypeRegistryDefault() {
        this.addCollectionType(Collection.class);
    }

    private void addCollectionType(Class<?> collectionType) {
        this.collectionTypes.add(collectionType);
        this.collectionTypesAsArray = this.collectionTypes.toArray(new Class[0]);
    }

    @Override
    public boolean isCollectionType(Class<?> cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    @Override
    public boolean isArrayType(Class<?> cls) {
        return cls.isArray();
    }

    @Override
    public Class<?>[] getCollectionType() {
        return this.collectionTypesAsArray;
    }

    @Override
    public OneToManyFeature.CollectionSemantics semanticsOf(Class<?> underlyingClass) {
        if (!Collection.class.isAssignableFrom(underlyingClass)) {
            return OneToManyFeature.CollectionSemantics.ARRAY;
        }
        if (List.class.isAssignableFrom(underlyingClass)) {
            return OneToManyFeature.CollectionSemantics.LIST;
        }
        if (Set.class.isAssignableFrom(underlyingClass)) {
            return OneToManyFeature.CollectionSemantics.SET;
        }
        return OneToManyFeature.CollectionSemantics.OTHER;
    }
}

