/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.classsubstitutor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutorAware;

public abstract class ClassSubstitutorAbstract
implements ClassSubstitutor {
    private final Set<Class<?>> classesToIgnore = new HashSet();

    public ClassSubstitutorAbstract() {
        this.ignore(DomainObjectContainer.class);
    }

    public void init() {
    }

    public void shutdown() {
    }

    @Override
    public Class<?> getClass(Class<?> cls) {
        if (this.shouldIgnore(cls)) {
            return null;
        }
        return cls;
    }

    private boolean shouldIgnore(Class<?> cls) {
        if (cls.isArray()) {
            return this.shouldIgnore(cls.getComponentType());
        }
        return this.classesToIgnore.contains(cls);
    }

    protected boolean ignore(Class<?> q) {
        return this.classesToIgnore.add(q);
    }

    public Set<Class<?>> getIgnoredClasses() {
        return Collections.unmodifiableSet(this.classesToIgnore);
    }

    public void injectInto(Object candidate) {
        if (ClassSubstitutorAware.class.isAssignableFrom(candidate.getClass())) {
            ClassSubstitutorAware cast = (ClassSubstitutorAware)ClassSubstitutorAware.class.cast(candidate);
            cast.setClassInstrumentor(this);
        }
    }
}

