/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.metamodel.adapter.ServicesProvider;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecoratorSet;
import org.apache.isis.core.metamodel.facets.object.bounded.BoundedFacetUtils;
import org.apache.isis.core.metamodel.layout.MemberLayoutArranger;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.noruntime.RuntimeContextNoRuntime;
import org.apache.isis.core.metamodel.spec.ObjectInstantiator;
import org.apache.isis.core.metamodel.spec.ObjectList;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationContext;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderAware;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.metamodel.spec.SpecificationLookupAware;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.specloader.ObjectReflector;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.core.metamodel.specloader.facetprocessor.FacetProcessor;
import org.apache.isis.core.metamodel.specloader.speccache.SpecificationCache;
import org.apache.isis.core.metamodel.specloader.speccache.SpecificationCacheDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.CreateObjectContext;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilderContext;
import org.apache.isis.core.metamodel.specloader.specimpl.IntrospectionContext;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.objectlist.ObjectSpecificationForObjectList;
import org.apache.isis.core.metamodel.specloader.traverser.SpecificationTraverser;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ObjectReflectorDefault
implements ObjectReflector,
DebuggableWithTitle {
    private static final Logger LOG = Logger.getLogger(ObjectReflectorDefault.class);
    private final IsisConfiguration configuration;
    private final ClassSubstitutor classSubstitutor;
    private final CollectionTypeRegistry collectionTypeRegistry;
    private final ProgrammingModel programmingModel;
    private final FacetProcessor facetProcessor;
    private final FacetDecoratorSet facetDecoratorSet;
    private RuntimeContext runtimeContext;
    private final SpecificationTraverser specificationTraverser;
    private final MemberLayoutArranger memberLayoutArranger;
    private List<Class<?>> serviceClasses = Lists.newArrayList();
    private final MetaModelValidator metaModelValidator;
    private final SpecificationCache cache;

    public ObjectReflectorDefault(IsisConfiguration configuration, ClassSubstitutor classSubstitutor, CollectionTypeRegistry collectionTypeRegistry, SpecificationTraverser specificationTraverser, MemberLayoutArranger memberLayoutArranger, ProgrammingModel programmingModel, Set<FacetDecorator> facetDecorators, MetaModelValidator metaModelValidator) {
        Ensure.ensureThatArg((Object)configuration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)classSubstitutor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)collectionTypeRegistry, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)specificationTraverser, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)memberLayoutArranger, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)programmingModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(facetDecorators, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)metaModelValidator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.configuration = configuration;
        this.classSubstitutor = classSubstitutor;
        this.collectionTypeRegistry = collectionTypeRegistry;
        this.programmingModel = programmingModel;
        this.specificationTraverser = specificationTraverser;
        this.memberLayoutArranger = memberLayoutArranger;
        this.facetDecoratorSet = new FacetDecoratorSet();
        for (FacetDecorator facetDecorator : facetDecorators) {
            this.facetDecoratorSet.add(facetDecorator);
        }
        this.metaModelValidator = metaModelValidator;
        this.facetProcessor = new FacetProcessor(configuration, collectionTypeRegistry, programmingModel);
        this.cache = new SpecificationCacheDefault();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info((Object)("finalizing reflector factory " + this));
    }

    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("initialising " + this));
        }
        if (this.runtimeContext == null) {
            this.runtimeContext = new RuntimeContextNoRuntime();
        }
        this.injectInto(this.runtimeContext);
        this.injectInto(this.specificationTraverser);
        this.injectInto(this.memberLayoutArranger);
        this.injectInto(this.metaModelValidator);
        this.runtimeContext.injectInto(this.facetProcessor);
        this.facetDecoratorSet.init();
        this.classSubstitutor.init();
        this.collectionTypeRegistry.init();
        this.specificationTraverser.init();
        this.facetProcessor.init();
        this.programmingModel.init();
        this.metaModelValidator.init();
        this.primeCache();
        this.metaModelValidator.validate();
    }

    private void primeCache() {
        for (Class<?> serviceClass : this.serviceClasses) {
            this.internalLoadSpecification(serviceClass);
        }
        this.loadAllSpecifications();
    }

    private void loadAllSpecifications() {
        List<Class<?>> newlyDiscoveredClasses = this.newlyDiscoveredClasses();
        while (newlyDiscoveredClasses.size() > 0) {
            for (Class<?> newClass : newlyDiscoveredClasses) {
                this.internalLoadSpecification(newClass);
            }
            newlyDiscoveredClasses = this.newlyDiscoveredClasses();
        }
    }

    private List<Class<?>> newlyDiscoveredClasses() {
        ArrayList newlyDiscoveredClasses = new ArrayList();
        Collection<ObjectSpecification> noSpecs = this.allSpecifications();
        try {
            for (ObjectSpecification noSpec : noSpecs) {
                this.getSpecificationTraverser().traverseReferencedClasses(noSpec, newlyDiscoveredClasses);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new IsisException((Throwable)ex);
        }
        return newlyDiscoveredClasses;
    }

    public void shutdown() {
        LOG.info((Object)("shutting down " + this));
        this.getCache().clear();
        this.facetDecoratorSet.shutdown();
    }

    @Override
    public final ObjectSpecification loadSpecification(String className) {
        Ensure.ensureThatArg((Object)className, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"specification class name must be specified");
        try {
            Class<?> cls = this.loadBuiltIn(className);
            return this.internalLoadSpecification(cls);
        }
        catch (ClassNotFoundException e) {
            ObjectSpecification spec = this.getCache().get(className);
            if (spec == null) {
                throw new IsisException("No such class available: " + className);
            }
            return spec;
        }
    }

    @Override
    public ObjectSpecification loadSpecification(Class<?> type) {
        return this.internalLoadSpecification(type);
    }

    private ObjectSpecification internalLoadSpecification(Class<?> type) {
        Class<?> substitutedType = this.getClassSubstitutor().getClass(type);
        return substitutedType != null ? this.loadSpecificationForSubstitutedClass(substitutedType) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectSpecification loadSpecificationForSubstitutedClass(Class<?> type) {
        SpecificationCache specificationCache;
        Assert.assertNotNull(type);
        String typeName = type.getName();
        SpecificationCache specificationCache2 = specificationCache = this.getCache();
        synchronized (specificationCache2) {
            ObjectSpecification spec = specificationCache.get(typeName);
            if (spec != null) {
                return spec;
            }
            ObjectSpecification specification = this.createSpecification(type);
            if (specification == null) {
                throw new IsisException("Failed to create specification for class " + typeName);
            }
            specificationCache.cache(typeName, specification);
            this.introspectSpecificationIfRequired(specification);
            return specification;
        }
    }

    @Override
    public boolean loadSpecifications(List<Class<?>> typesToLoad, Class<?> typeToIgnore) {
        boolean anyLoadedAsNull = false;
        for (Class<?> typeToLoad : typesToLoad) {
            if (typeToLoad == typeToIgnore) continue;
            ObjectSpecification noSpec = this.internalLoadSpecification(typeToLoad);
            boolean loadedAsNull = noSpec == null;
            anyLoadedAsNull = loadedAsNull || anyLoadedAsNull;
        }
        return anyLoadedAsNull;
    }

    @Override
    public boolean loadSpecifications(List<Class<?>> typesToLoad) {
        return this.loadSpecifications(typesToLoad, null);
    }

    private ObjectSpecification createSpecification(Class<?> cls) {
        AuthenticationSessionProvider authenticationSessionProvider = this.getRuntimeContext().getAuthenticationSessionProvider();
        SpecificationLookup specificationLookup = this.getRuntimeContext().getSpecificationLookup();
        ServicesProvider servicesProvider = this.getRuntimeContext().getServicesProvider();
        ObjectInstantiator objectInstantiator = this.getRuntimeContext().getObjectInstantiator();
        SpecificationContext specContext = new SpecificationContext(authenticationSessionProvider, servicesProvider, objectInstantiator, specificationLookup);
        if (ObjectList.class.isAssignableFrom(cls)) {
            return new ObjectSpecificationForObjectList(specContext);
        }
        ObjectReflectorDefault specificationLoader = this;
        AdapterMap adapterMap = this.getRuntimeContext().getAdapterMap();
        ObjectMemberContext objectMemberContext = new ObjectMemberContext(authenticationSessionProvider, specificationLookup, adapterMap, this.getRuntimeContext().getQuerySubmitter(), this.collectionTypeRegistry);
        IntrospectionContext introspectionContext = new IntrospectionContext(this.getClassSubstitutor(), this.getMemberLayoutArranger());
        DependencyInjector dependencyInjector = this.getRuntimeContext().getDependencyInjector();
        CreateObjectContext createObjectContext = new CreateObjectContext(adapterMap, dependencyInjector);
        FacetedMethodsBuilderContext facetedMethodsBuilderContext = new FacetedMethodsBuilderContext(specificationLoader, this.classSubstitutor, this.specificationTraverser, this.facetProcessor);
        return new ObjectSpecificationDefault(cls, facetedMethodsBuilderContext, introspectionContext, specContext, objectMemberContext, createObjectContext);
    }

    private Class<?> loadBuiltIn(String className) throws ClassNotFoundException {
        Class builtIn = JavaClassUtils.getBuiltIn((String)className);
        if (builtIn != null) {
            return builtIn;
        }
        return Class.forName(className);
    }

    @Override
    public Collection<ObjectSpecification> allSpecifications() {
        return this.getCache().allSpecifications();
    }

    @Override
    public boolean loaded(Class<?> cls) {
        return this.loaded(cls.getName());
    }

    @Override
    public boolean loaded(String fullyQualifiedClassName) {
        return this.getCache().get(fullyQualifiedClassName) != null;
    }

    private ObjectSpecification introspectSpecificationIfRequired(ObjectSpecification spec) {
        if (!spec.isIntrospected()) {
            spec.introspectTypeHierarchyAndMembers();
            this.facetDecoratorSet.decorate(spec);
            spec.updateFromFacetValues();
        }
        return spec;
    }

    public void injectInto(Object candidate) {
        Object cast;
        Class<?> candidateClass = candidate.getClass();
        if (SpecificationLoaderAware.class.isAssignableFrom(candidateClass)) {
            cast = (SpecificationLoaderAware)SpecificationLoaderAware.class.cast(candidate);
            cast.setSpecificationLoader(this);
        }
        if (SpecificationLookupAware.class.isAssignableFrom(candidateClass)) {
            cast = (SpecificationLookupAware)SpecificationLookupAware.class.cast(candidate);
            cast.setSpecificationLookup(this);
        }
        this.getClassSubstitutor().injectInto(candidate);
        this.getCollectionTypeRegistry().injectInto(candidate);
    }

    public void debugData(DebugBuilder str) {
        this.facetDecoratorSet.debugData(str);
        str.appendln();
        str.appendTitle("Specifications");
        ArrayList specs = Lists.newArrayList(this.allSpecifications());
        Collections.sort(specs, ObjectSpecification.COMPARATOR_SHORT_IDENTIFIER_IGNORE_CASE);
        for (ObjectSpecification spec : specs) {
            str.append((Object)(spec.isAbstract() ? "A" : "."));
            str.append((Object)(spec.isService() ? "S" : "."));
            str.append((Object)(BoundedFacetUtils.isBoundedSet(spec) ? "B" : "."));
            str.append((Object)(spec.isCollection() ? "C" : "."));
            str.append((Object)(spec.isNotCollection() ? "O" : "."));
            str.append((Object)".");
            str.append((Object)(spec.isParseable() ? "P" : "."));
            str.append((Object)(spec.isEncodeable() ? "E" : "."));
            str.append((Object)(spec.isValueOrIsAggregated() ? "A" : "."));
            str.append((Object)(!spec.isCollectionOrIsAggregated() ? "I" : "."));
            str.append((Object)"  ");
            str.append((Object)spec.getShortIdentifier());
            str.append((Object)"  [fqc=");
            str.append((Object)spec.getFullIdentifier());
            str.append((Object)",type=");
            str.append((Object)spec.getClass().getName());
            str.appendln("]");
        }
    }

    public String debugTitle() {
        return "Reflector";
    }

    public FacetProcessor getFacetProcessor() {
        return this.facetProcessor;
    }

    private SpecificationCache getCache() {
        return this.cache;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public List<Class<?>> getServiceClasses() {
        return Collections.unmodifiableList(this.serviceClasses);
    }

    @Override
    public void setServiceClasses(List<Class<?>> serviceClasses) {
        this.serviceClasses = serviceClasses;
    }

    protected IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    protected CollectionTypeRegistry getCollectionTypeRegistry() {
        return this.collectionTypeRegistry;
    }

    protected ClassSubstitutor getClassSubstitutor() {
        return this.classSubstitutor;
    }

    protected SpecificationTraverser getSpecificationTraverser() {
        return this.specificationTraverser;
    }

    protected ProgrammingModel getProgrammingModelFacets() {
        return this.programmingModel;
    }

    protected MemberLayoutArranger getMemberLayoutArranger() {
        return this.memberLayoutArranger;
    }

    protected MetaModelValidator getMetaModelValidator() {
        return this.metaModelValidator;
    }

    protected Set<FacetDecorator> getFacetDecoratorSet() {
        return this.facetDecoratorSet.getFacetDecorators();
    }
}

