/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;

public class ObjectAssociationFilters {
    public static final Filter<ObjectAssociation> PROPERTIES = new Filter<ObjectAssociation>(){

        public boolean accept(ObjectAssociation association) {
            return association.isOneToOneAssociation();
        }
    };
    public static final Filter<ObjectAssociation> ALL = new Filter<ObjectAssociation>(){

        public boolean accept(ObjectAssociation property) {
            return true;
        }
    };
    public static final Filter<ObjectAssociation> COLLECTIONS = new Filter<ObjectAssociation>(){

        public boolean accept(ObjectAssociation property) {
            return property.isOneToManyAssociation();
        }
    };
    public static final Filter<ObjectAssociation> STATICALLY_VISIBLE_ASSOCIATIONS = new Filter<ObjectAssociation>(){

        public boolean accept(ObjectAssociation property) {
            return !property.isAlwaysHidden();
        }
    };

    private ObjectAssociationFilters() {
    }

    public static Filter<ObjectAssociation> dynamicallyVisible(final AuthenticationSession session, final ObjectAdapter target) {
        return new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation objectAssociation) {
                Consent visible = objectAssociation.isVisible(session, target);
                return visible.isAllowed();
            }
        };
    }
}

