/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.container;

import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.PersistFailedException;
import org.apache.isis.applib.RepositoryException;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.applib.security.RoleMemento;
import org.apache.isis.applib.security.UserMemento;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAware;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.DomainObjectServices;
import org.apache.isis.core.metamodel.adapter.DomainObjectServicesAware;
import org.apache.isis.core.metamodel.adapter.LocalizationProvider;
import org.apache.isis.core.metamodel.adapter.LocalizationProviderAware;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectDirtier;
import org.apache.isis.core.metamodel.adapter.ObjectDirtierAware;
import org.apache.isis.core.metamodel.adapter.ObjectPersistor;
import org.apache.isis.core.metamodel.adapter.ObjectPersistorAware;
import org.apache.isis.core.metamodel.adapter.QuerySubmitter;
import org.apache.isis.core.metamodel.adapter.QuerySubmitterAware;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.adapter.oid.AggregatedOid;
import org.apache.isis.core.metamodel.adapter.util.AdapterUtils;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.services.container.query.QueryFindByPattern;
import org.apache.isis.core.metamodel.services.container.query.QueryFindByTitle;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.metamodel.spec.SpecificationLookupAware;

public class DomainObjectContainerDefault
implements DomainObjectContainer,
QuerySubmitterAware,
ObjectDirtierAware,
DomainObjectServicesAware,
ObjectPersistorAware,
SpecificationLookupAware,
AuthenticationSessionProviderAware,
AdapterMapAware,
LocalizationProviderAware {
    private ObjectDirtier objectDirtier;
    private ObjectPersistor objectPersistor;
    private QuerySubmitter querySubmitter;
    private SpecificationLookup specificationLookup;
    private DomainObjectServices domainObjectServices;
    private AuthenticationSessionProvider authenticationSessionProvider;
    private AdapterMap adapterMap;
    private LocalizationProvider localizationProvider;

    public String titleOf(Object domainObject) {
        ObjectAdapter objectAdapter = this.adapterMap.adapterFor(domainObject);
        return objectAdapter.getSpecification().getTitle(objectAdapter, this.localizationProvider.getLocalization());
    }

    public <T> T newTransientInstance(Class<T> ofClass) {
        ObjectSpecification spec = this.getSpecificationLookup().loadSpecification(ofClass);
        if (spec.isAggregated()) {
            return this.newAggregatedInstance(this, ofClass);
        }
        ObjectAdapter adapter = this.doCreateTransientInstance(spec);
        return (T)adapter.getObject();
    }

    public <T> T newAggregatedInstance(Object parent, Class<T> ofClass) {
        ObjectSpecification spec = this.getSpecificationLookup().loadSpecification(ofClass);
        if (!spec.isAggregated()) {
            throw new IsisException("Cannot instantiate an object unless it is marked as Aggregated using the newAggregatedInstance method: " + ofClass);
        }
        ObjectAdapter adapter = this.doCreateAggregatedInstance(spec, parent);
        if (adapter.getOid() instanceof AggregatedOid) {
            return (T)adapter.getObject();
        }
        throw new IsisException("Object instatiated but was not given a AggregatedOid: " + ofClass);
    }

    public <T> T newPersistentInstance(Class<T> ofClass) {
        T newInstance = this.newTransientInstance(ofClass);
        this.persist(newInstance);
        return newInstance;
    }

    public <T> T newInstance(Class<T> ofClass, Object object) {
        if (this.isPersistent(object)) {
            return this.newPersistentInstance(ofClass);
        }
        return this.newTransientInstance(ofClass);
    }

    protected ObjectAdapter doCreateTransientInstance(ObjectSpecification spec) {
        return this.getDomainObjectServices().createTransientInstance(spec);
    }

    private ObjectAdapter doCreateAggregatedInstance(ObjectSpecification spec, Object parent) {
        ObjectAdapter parentAdapter = this.getAdapterMap().getAdapterFor(parent);
        return this.getDomainObjectServices().createAggregatedInstance(spec, parentAdapter);
    }

    public void remove(Object persistentObject) {
        if (persistentObject == null) {
            throw new IllegalArgumentException("Must specify a reference for disposing an object");
        }
        ObjectAdapter adapter = this.getAdapterMap().getAdapterFor(persistentObject);
        if (!this.isPersistent(persistentObject)) {
            throw new RepositoryException("Object not persistent: " + adapter);
        }
        this.getObjectPersistor().remove(adapter);
    }

    public void removeIfNotAlready(Object object) {
        if (!this.isPersistent(object)) {
            return;
        }
        this.remove(object);
    }

    public void resolve(Object parent) {
        this.getDomainObjectServices().resolve(parent);
    }

    public void resolve(Object parent, Object field) {
        this.getDomainObjectServices().resolve(parent, field);
    }

    public void objectChanged(Object object) {
        this.getObjectDirtier().objectChanged(object);
    }

    public boolean flush() {
        return this.getDomainObjectServices().flush();
    }

    public void commit() {
        this.getDomainObjectServices().commit();
    }

    public boolean isValid(Object domainObject) {
        return this.validate(domainObject) == null;
    }

    public String validate(Object domainObject) {
        ObjectAdapter adapter = this.getAdapterMap().adapterFor(domainObject);
        InteractionResult validityResult = adapter.getSpecification().isValidResult(adapter);
        return validityResult.getReason();
    }

    public boolean isPersistent(Object domainObject) {
        ObjectAdapter adapter = this.getAdapterMap().adapterFor(domainObject);
        return adapter.isPersistent();
    }

    public void persist(Object transientObject) {
        ObjectAdapter adapter = this.getAdapterMap().getAdapterFor(transientObject);
        if (adapter.isAggregated()) {
            return;
        }
        if (this.isPersistent(transientObject)) {
            throw new PersistFailedException("Object already persistent: " + adapter);
        }
        this.getObjectPersistor().makePersistent(adapter);
    }

    public void persistIfNotAlready(Object object) {
        if (this.isPersistent(object)) {
            return;
        }
        this.persist(object);
    }

    public UserMemento getUser() {
        AuthenticationSession session = this.getAuthenticationSessionProvider().getAuthenticationSession();
        String name = session.getUserName();
        List<RoleMemento> roleMementos = this.asRoleMementos(session.getRoles());
        UserMemento user = new UserMemento(name, roleMementos);
        return user;
    }

    private List<RoleMemento> asRoleMementos(List<String> roles) {
        ArrayList<RoleMemento> mementos = new ArrayList<RoleMemento>();
        if (roles != null) {
            for (String role : roles) {
                mementos.add(new RoleMemento(role));
            }
        }
        return mementos;
    }

    public String getProperty(String name) {
        return this.getDomainObjectServices().getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        return value == null ? defaultValue : value;
    }

    public List<String> getPropertyNames() {
        return this.getDomainObjectServices().getPropertyNames();
    }

    public void informUser(String message) {
        this.getDomainObjectServices().informUser(message);
    }

    public void raiseError(String message) {
        this.getDomainObjectServices().raiseError(message);
    }

    public void warnUser(String message) {
        this.getDomainObjectServices().warnUser(message);
    }

    public <T> List<T> allInstances(Class<T> type) {
        return this.allMatches((Query<T>)new QueryFindAllInstances(type));
    }

    public <T> List<T> allMatches(Class<T> cls, Filter<? super T> filter) {
        List<T> allInstances = this.allInstances(cls);
        ArrayList<T> filtered = new ArrayList<T>();
        for (T instance : allInstances) {
            if (!filter.accept(instance)) continue;
            filtered.add(instance);
        }
        return filtered;
    }

    public <T> List<T> allMatches(Class<T> type, T pattern) {
        Assert.assertTrue((String)"pattern not compatible with type", (boolean)type.isAssignableFrom(pattern.getClass()));
        return this.allMatches((Query<T>)new QueryFindByPattern<T>(type, pattern));
    }

    public <T> List<T> allMatches(Class<T> type, String title) {
        return this.allMatches((Query<T>)new QueryFindByTitle<T>(type, title));
    }

    public <T> List<T> allMatches(Query<T> query) {
        List<ObjectAdapter> allMatching = this.getQuerySubmitter().allMatchingQuery(query);
        return AdapterUtils.unwrap(allMatching);
    }

    public <T> T firstMatch(Class<T> cls, Filter<T> filter) {
        List<T> allInstances = this.allInstances(cls);
        for (T instance : allInstances) {
            if (!filter.accept(instance)) continue;
            return instance;
        }
        return null;
    }

    public <T> T firstMatch(Class<T> type, T pattern) {
        List<T> instances = this.allMatches(type, pattern);
        return this.firstInstanceElseNull(instances);
    }

    public <T> T firstMatch(Class<T> type, String title) {
        List<T> instances = this.allMatches(type, title);
        return this.firstInstanceElseNull(instances);
    }

    public <T> T firstMatch(Query<T> query) {
        ObjectAdapter firstMatching = this.getQuerySubmitter().firstMatchingQuery(query);
        return (T)AdapterUtils.unwrap(firstMatching);
    }

    public <T> T uniqueMatch(Class<T> type, Filter<T> filter) {
        List<Filter<T>> instances = this.allMatches(type, (T)filter);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more than one instance of " + type + " matching filter " + filter);
        }
        return (T)this.firstInstanceElseNull(instances);
    }

    public <T> T uniqueMatch(Class<T> type, T pattern) {
        List<T> instances = this.allMatches(type, pattern);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance of " + type + " matching pattern " + pattern);
        }
        return this.firstInstanceElseNull(instances);
    }

    public <T> T uniqueMatch(Class<T> type, String title) {
        List<T> instances = this.allMatches(type, title);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance of " + type + " with title " + title);
        }
        return this.firstInstanceElseNull(instances);
    }

    public <T> T uniqueMatch(Query<T> query) {
        List<T> instances = this.allMatches(query);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance for query:" + query.getDescription());
        }
        return this.firstInstanceElseNull(instances);
    }

    private <T> T firstInstanceElseNull(List<T> instances) {
        return instances.size() == 0 ? null : (T)instances.get(0);
    }

    protected QuerySubmitter getQuerySubmitter() {
        return this.querySubmitter;
    }

    @Override
    public void setQuerySubmitter(QuerySubmitter querySubmitter) {
        this.querySubmitter = querySubmitter;
    }

    protected DomainObjectServices getDomainObjectServices() {
        return this.domainObjectServices;
    }

    @Override
    public void setDomainObjectServices(DomainObjectServices domainObjectServices) {
        this.domainObjectServices = domainObjectServices;
    }

    protected SpecificationLookup getSpecificationLookup() {
        return this.specificationLookup;
    }

    @Override
    public void setSpecificationLookup(SpecificationLookup specificationLookup) {
        this.specificationLookup = specificationLookup;
    }

    protected AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    public void setAuthenticationSessionProvider(AuthenticationSessionProvider authenticationSessionProvider) {
        this.authenticationSessionProvider = authenticationSessionProvider;
    }

    protected AdapterMap getAdapterMap() {
        return this.adapterMap;
    }

    @Override
    public void setAdapterMap(AdapterMap adapterManager) {
        this.adapterMap = adapterManager;
    }

    protected ObjectDirtier getObjectDirtier() {
        return this.objectDirtier;
    }

    @Override
    public void setObjectDirtier(ObjectDirtier objectDirtier) {
        this.objectDirtier = objectDirtier;
    }

    protected ObjectPersistor getObjectPersistor() {
        return this.objectPersistor;
    }

    @Override
    public void setObjectPersistor(ObjectPersistor objectPersistor) {
        this.objectPersistor = objectPersistor;
    }

    @Override
    public void setLocalizationProvider(LocalizationProvider localizationProvider) {
        this.localizationProvider = localizationProvider;
    }
}

