/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.lang.CastUtils;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ServicesInjectorAware;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class ServicesInjectorAbstract
implements ServicesInjector {
    private static final Logger LOG = Logger.getLogger(ServicesInjectorAbstract.class);
    private final List<Object> services = Lists.newArrayList();
    private DomainObjectContainer container;

    public void open() {
        this.autowireServicesAndContainer();
    }

    public void close() {
    }

    @Override
    public DomainObjectContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(DomainObjectContainer container) {
        Ensure.ensureThatArg((Object)container, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.container = container;
    }

    @Override
    public void setServices(List<Object> services) {
        this.services.clear();
        this.addServices(services);
        this.autowireServicesAndContainer();
    }

    @Override
    public List<Object> getRegisteredServices() {
        return Collections.unmodifiableList(this.services);
    }

    private void addServices(List<Object> services) {
        for (Object service : services) {
            if (service instanceof List) {
                List serviceList = CastUtils.listOf((Object)service, Object.class);
                this.addServices(serviceList);
                continue;
            }
            this.addService(service);
        }
    }

    private boolean addService(Object service) {
        return this.services.add(service);
    }

    @Override
    public void injectDependencies(Object object) {
        Assert.assertNotNull((String)"no container", (Object)this.container);
        Assert.assertNotNull((String)"no services", this.services);
        ArrayList servicesCopy = Lists.newArrayList(this.services);
        servicesCopy.add(this.container);
        ServicesInjectorAbstract.injectServices(object, servicesCopy);
    }

    @Override
    public void injectDependencies(List<Object> objects) {
        for (Object object : objects) {
            this.injectDependencies(object);
        }
    }

    public void injectInto(Object candidate) {
        if (ServicesInjectorAware.class.isAssignableFrom(candidate.getClass())) {
            ServicesInjectorAware cast = (ServicesInjectorAware)ServicesInjectorAware.class.cast(candidate);
            cast.setServicesInjector(this);
        }
    }

    private static void injectServices(Object object, List<Object> services) {
        Class<?> cls = object.getClass();
        for (Object service : services) {
            Class<?> serviceClass = service.getClass();
            Method[] methods = cls.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Class<?>[] parameterTypes;
                if (!methods[j].getName().startsWith("set") || (parameterTypes = methods[j].getParameterTypes()).length != 1 || parameterTypes[0] == Object.class || !parameterTypes[0].isAssignableFrom(serviceClass)) continue;
                methods[j].setAccessible(true);
                ServicesInjectorAbstract.invokeSetMethod(methods[j], object, service);
            }
        }
    }

    private static void invokeMethod(Method method, Object target, Object[] parameters) {
        try {
            method.invoke(target, parameters);
        }
        catch (SecurityException e) {
            throw new MetaModelException(String.format("Cannot access the %s method in %s", method.getName(), target.getClass().getName()));
        }
        catch (IllegalArgumentException e1) {
            throw new MetaModelException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new MetaModelException(String.format("Cannot access the %s method in %s", method.getName(), target.getClass().getName()));
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new MetaModelException(targetException);
        }
    }

    private static void invokeSetMethod(Method set, Object target, Object parameter) {
        Object[] parameters = new Object[]{parameter};
        ServicesInjectorAbstract.invokeMethod(set, target, parameters);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("injected " + parameter + " into " + new ToString(target)));
        }
    }

    private void autowireServicesAndContainer() {
        this.injectDependencies(this.services);
        this.injectDependencies(this.container);
    }
}

