/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.runtimecontext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContextAware;
import org.apache.isis.core.metamodel.services.container.DomainObjectContainerAware;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderAware;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.metamodel.spec.SpecificationLookupDelegator;

public abstract class RuntimeContextAbstract
implements RuntimeContext,
SpecificationLoaderAware,
DomainObjectContainerAware {
    private final SpecificationLookupDelegator specificationLookupDelegator = new SpecificationLookupDelegator();
    private DomainObjectContainer container;
    private Properties properties;

    public void injectInto(Object candidate) {
        if (RuntimeContextAware.class.isAssignableFrom(candidate.getClass())) {
            RuntimeContextAware cast = (RuntimeContextAware)RuntimeContextAware.class.cast(candidate);
            cast.setRuntimeContext(this);
        }
        this.injectSubcomponentsInto(candidate);
    }

    protected void injectSubcomponentsInto(Object candidate) {
        this.getAdapterMap().injectInto(candidate);
        this.getAuthenticationSessionProvider().injectInto(candidate);
        this.getDependencyInjector().injectInto(candidate);
        this.getDomainObjectServices().injectInto(candidate);
        this.getLocalizationProvider().injectInto(candidate);
        this.getObjectInstantiator().injectInto(candidate);
        this.getObjectDirtier().injectInto(candidate);
        this.getObjectPersistor().injectInto(candidate);
        this.getQuerySubmitter().injectInto(candidate);
        this.getServicesProvider().injectInto(candidate);
        this.getSpecificationLookup().injectInto(candidate);
    }

    @Override
    public SpecificationLookup getSpecificationLookup() {
        return this.specificationLookupDelegator;
    }

    @Override
    public void setSpecificationLoader(final SpecificationLoader specificationLoader) {
        this.specificationLookupDelegator.setDelegate(new SpecificationLookup(){

            public void injectInto(Object candidate) {
                specificationLoader.injectInto(candidate);
            }

            @Override
            public ObjectSpecification loadSpecification(Class<?> cls) {
                return specificationLoader.loadSpecification(cls);
            }

            @Override
            public Collection<ObjectSpecification> allSpecifications() {
                return specificationLoader.allSpecifications();
            }
        });
    }

    protected DomainObjectContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(DomainObjectContainer container) {
        this.container = container;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public List<String> getPropertyNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Object key : this.properties.keySet()) {
            list.add((String)key);
        }
        return list;
    }
}

