/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.progmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;

public abstract class ProgrammingModelAbstract
implements ProgrammingModel {
    private final List<FacetFactory> facetFactories = new ArrayList<FacetFactory>();
    private final List<Class<? extends FacetFactory>> facetFactoryClasses = new ArrayList<Class<? extends FacetFactory>>();

    @Override
    public final List<FacetFactory> getList() {
        return Collections.unmodifiableList(this.facetFactories);
    }

    @Override
    public final void addFactory(Class<? extends FacetFactory> factoryClass) {
        this.facetFactoryClasses.add(factoryClass);
    }

    @Override
    public final void removeFactory(Class<? extends FacetFactory> factoryClass) {
        this.facetFactoryClasses.remove(factoryClass);
    }

    @Override
    public void init() {
        for (Class<? extends FacetFactory> factoryClass : this.facetFactoryClasses) {
            FacetFactory facetFactory = (FacetFactory)InstanceUtil.createInstance(factoryClass);
            this.facetFactories.add(facetFactory);
        }
    }
}

