/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.methodutils;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public final class MethodFinderUtils {
    private static Map<Class<?>, Class<?>> boxedClasses = Maps.newHashMap();

    private MethodFinderUtils() {
    }

    public static Method removeMethod(List<Method> methods, MethodScope methodScope, String name, Class<?> returnType, Class<?>[] paramTypes) {
        int idx = MethodFinderUtils.findMethodIndex(methods, methodScope, name, returnType, paramTypes);
        if (idx != -1) {
            Method method = methods.get(idx);
            methods.set(idx, null);
            return method;
        }
        return null;
    }

    public static Method findMethod(List<Method> methods, MethodScope methodScope, String name, Class<?> returnType, Class<?>[] paramTypes) {
        int idx = MethodFinderUtils.findMethodIndex(methods, methodScope, name, returnType, paramTypes);
        return idx != -1 ? methods.get(idx) : null;
    }

    public static int findMethodIndex(List<Method> methods, MethodScope methodScope, String name, Class<?> returnType, Class<?>[] paramTypes) {
        int idx = -1;
        block0: for (int i = 0; i < methods.size(); ++i) {
            Method method;
            int modifiers;
            if (methods.get(i) == null || !Modifier.isPublic(modifiers = (method = methods.get(i)).getModifiers()) || !MethodFinderUtils.inScope(methodScope, method) || !method.getName().equals(name) || returnType != null && returnType != method.getReturnType()) continue;
            if (paramTypes != null) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (paramTypes.length != parameterTypes.length) continue;
                for (int c = 0; c < paramTypes.length; ++c) {
                    if (paramTypes[c] != null && paramTypes[c] != parameterTypes[c]) continue block0;
                }
            }
            idx = i;
            break;
        }
        return idx;
    }

    public static boolean inScope(MethodScope methodScope, Method method) {
        boolean isStatic = JavaClassUtils.isStatic((Method)method);
        return isStatic && methodScope == MethodScope.CLASS || !isStatic && methodScope == MethodScope.OBJECT;
    }

    public static List<Method> removeMethods(List<Method> methods, MethodScope forClass, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
        ArrayList<Method> validMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.size(); ++i) {
            Method method;
            if (methods.get(i) == null || !MethodFinderUtils.inScope(forClass, method = methods.get(i))) continue;
            boolean goodPrefix = method.getName().startsWith(prefix);
            boolean goodCount = method.getParameterTypes().length == paramCount;
            Class<?> type = method.getReturnType();
            boolean goodReturn = MethodFinderUtils.returnTypeCompatible(returnType, canBeVoid, type);
            if (!goodPrefix || !goodCount || !goodReturn) continue;
            validMethods.add(method);
            methods.set(i, null);
        }
        return validMethods;
    }

    private static boolean returnTypeCompatible(Class<?> returnType, boolean canBeVoid, Class<?> type) {
        if (returnType == null) {
            return true;
        }
        if (canBeVoid && type == Void.TYPE) {
            return true;
        }
        if (type.isPrimitive()) {
            return returnType.isAssignableFrom(boxedClasses.get(type));
        }
        return returnType.isAssignableFrom(type);
    }

    public static void findPrefixedInstanceMethods(Method[] methods, String prefix, List<Method> candidates) {
        for (Method method : methods) {
            boolean goodCount;
            if (method == null || JavaClassUtils.isStatic((Method)method)) continue;
            boolean goodPrefix = method.getName().startsWith(prefix);
            boolean bl = goodCount = method.getParameterTypes().length == 0;
            if (!goodPrefix || !goodCount) continue;
            candidates.add(method);
        }
    }

    static {
        boxedClasses.put(Boolean.TYPE, Boolean.class);
        boxedClasses.put(Character.TYPE, Character.class);
        boxedClasses.put(Byte.TYPE, Byte.class);
        boxedClasses.put(Short.TYPE, Short.class);
        boxedClasses.put(Integer.TYPE, Integer.class);
        boxedClasses.put(Long.TYPE, Long.class);
        boxedClasses.put(Float.TYPE, Float.class);
        boxedClasses.put(Double.TYPE, Double.class);
        boxedClasses.put(Void.TYPE, Void.class);
    }
}

