/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.layout.ordermethod;

import java.util.List;
import java.util.StringTokenizer;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.layout.OrderSet;

public class SimpleOrderSet
extends OrderSet {
    private final SimpleOrderSet parent;
    private final List<FacetedMethod> members;

    public static SimpleOrderSet createOrderSet(String order, List<FacetedMethod> members) {
        SimpleOrderSet set = new SimpleOrderSet(members);
        StringTokenizer st = new StringTokenizer(order, ",");
        while (st.hasMoreTokens()) {
            String element = st.nextToken().trim();
            boolean ends = element.endsWith(")");
            if (ends) {
                element = element.substring(0, element.length() - 1).trim();
            }
            if (element.startsWith("(")) {
                int colon = element.indexOf(58);
                String groupName = element.substring(1, colon).trim();
                element = element.substring(colon + 1).trim();
                set = set.createSubOrderSet(groupName, element);
            } else {
                set.add(element);
            }
            if (!ends) continue;
            set = set.parent;
        }
        set.addAnyRemainingMember();
        return set;
    }

    private SimpleOrderSet(List<FacetedMethod> members) {
        super("");
        this.members = members;
        this.parent = null;
    }

    private SimpleOrderSet(SimpleOrderSet set, String groupName, String name, List<FacetedMethod> members) {
        super(groupName);
        this.parent = set;
        this.parent.addElement(this);
        this.members = members;
        this.add(name);
    }

    private void add(String name) {
        FacetedMethod memberWithName = this.getMemberWithName(name);
        if (memberWithName != null) {
            this.addElement(memberWithName);
        }
    }

    private void addAnyRemainingMember() {
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.get(i) == null) continue;
            FacetedMethod member = this.members.get(i);
            this.addElement(member);
        }
    }

    private SimpleOrderSet createSubOrderSet(String groupName, String memberName) {
        return new SimpleOrderSet(this, groupName, memberName, this.members);
    }

    private FacetedMethod getMemberWithName(String name) {
        String searchName = NameUtils.simpleName((String)name);
        for (int i = 0; i < this.members.size(); ++i) {
            String testName;
            FacetedMethod member = this.members.get(i);
            if (member == null || !(testName = NameUtils.simpleName((String)member.getIdentifier().getMemberName())).equals(searchName)) continue;
            this.members.set(i, null);
            return member;
        }
        return null;
    }
}

