/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.layout.memberorderfacet;

import java.util.Comparator;
import java.util.StringTokenizer;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.layout.OrderSet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberIdentifierComparator;
import org.apache.isis.core.metamodel.layout.memberorderfacet.OrderSetGroupNameComparator;

public class MemberOrderComparator
implements Comparator<Object> {
    private final boolean ensureInSameGroup;
    private final MemberIdentifierComparator fallbackComparator = new MemberIdentifierComparator();
    private final OrderSetGroupNameComparator orderSetComparator = new OrderSetGroupNameComparator(true);

    public MemberOrderComparator(boolean ensureGroupIsSame) {
        this.ensureInSameGroup = ensureGroupIsSame;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof FacetedMethod && o2 instanceof FacetedMethod) {
            return this.compare((FacetedMethod)o1, (FacetedMethod)o2);
        }
        if (o1 instanceof OrderSet && o2 instanceof OrderSet) {
            return this.orderSetComparator.compare((OrderSet)o1, (OrderSet)o2);
        }
        if (o1 instanceof FacetedMethod && o2 instanceof OrderSet) {
            return -1;
        }
        if (o1 instanceof OrderSet && o2 instanceof FacetedMethod) {
            return 1;
        }
        throw new IllegalArgumentException("can only compare MemberPeers and OrderSets");
    }

    @Override
    public int compare(FacetedMethod o1, FacetedMethod o2) {
        MemberOrderFacet m1 = this.getMemberOrder(o1);
        MemberOrderFacet m2 = this.getMemberOrder(o2);
        if (m1 == null && m2 == null) {
            return this.fallbackComparator.compare(o1, o2);
        }
        if (m1 == null && m2 != null) {
            return 1;
        }
        if (m1 != null && m2 == null) {
            return -1;
        }
        if (this.ensureInSameGroup && !m1.name().equals(m2.name())) {
            throw new IllegalArgumentException("Not in same group");
        }
        String sequence1 = m1.sequence();
        String sequence2 = m2.sequence();
        String[] components1 = MemberOrderComparator.componentsFor(sequence1);
        String[] components2 = MemberOrderComparator.componentsFor(sequence2);
        int length1 = components1.length;
        int length2 = components2.length;
        if (length1 == 0 && length2 == 0) {
            return this.fallbackComparator.compare(o1, o2);
        }
        int n = 0;
        int length;
        while (length1 >= (length = n + 1) || length2 < length) {
            if (length2 < length && length1 >= length) {
                return 1;
            }
            if (length1 < length && length2 < length) {
                return this.fallbackComparator.compare(o1, o2);
            }
            int componentCompare = 0;
            try {
                Integer c1 = Integer.valueOf(components1[n]);
                Integer c2 = Integer.valueOf(components2[n]);
                componentCompare = c1.compareTo(c2);
            }
            catch (NumberFormatException nfe) {
                componentCompare = components1[n].compareTo(components2[n]);
            }
            if (componentCompare != 0) {
                return componentCompare;
            }
            ++n;
        }
        return -1;
    }

    private static String[] componentsFor(String sequence) {
        StringTokenizer tokens = new StringTokenizer(sequence, ".", false);
        String[] components = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            components[i] = tokens.nextToken();
            ++i;
        }
        return components;
    }

    private MemberOrderFacet getMemberOrder(FacetHolder facetHolder) {
        return facetHolder.getFacet(MemberOrderFacet.class);
    }
}

