/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.layout.memberorderfacet;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.layout.OrderSet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberIdentifierComparator;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderComparator;

public class DeweyOrderSet
extends OrderSet {
    public static DeweyOrderSet createOrderSet(List<FacetedMethod> facetedMethods) {
        TreeMap sortedMembersByGroup = Maps.newTreeMap();
        TreeSet nonAnnotatedGroup = Sets.newTreeSet((Comparator)new MemberIdentifierComparator());
        for (FacetedMethod facetedMethod : facetedMethods) {
            MemberOrderFacet memberOrder = facetedMethod.getFacet(MemberOrderFacet.class);
            if (memberOrder == null) {
                nonAnnotatedGroup.add(facetedMethod);
                continue;
            }
            SortedSet<FacetedMethod> sortedMembersForGroup = DeweyOrderSet.getSortedSet(sortedMembersByGroup, memberOrder.name());
            sortedMembersForGroup.add(facetedMethod);
        }
        SortedSet<FacetedMethod> defaultSet = DeweyOrderSet.getSortedSet(sortedMembersByGroup, "");
        defaultSet.addAll(nonAnnotatedGroup);
        Set groupNames = sortedMembersByGroup.keySet();
        TreeMap orderSetsByGroup = Maps.newTreeMap();
        Iterator i$ = groupNames.iterator();
        while (i$.hasNext()) {
            String string;
            String groupName = string = (String)i$.next();
            DeweyOrderSet deweyOrderSet = new DeweyOrderSet(groupName);
            orderSetsByGroup.put(groupName, deweyOrderSet);
            DeweyOrderSet.ensureParentFor(orderSetsByGroup, deweyOrderSet);
        }
        for (String groupName : groupNames) {
            DeweyOrderSet deweyOrderSet = (DeweyOrderSet)orderSetsByGroup.get(groupName);
            SortedSet sortedMembers = (SortedSet)sortedMembersByGroup.get(groupName);
            deweyOrderSet.addAll(sortedMembers);
            deweyOrderSet.copyOverChildren();
        }
        return (DeweyOrderSet)orderSetsByGroup.get("");
    }

    private static void ensureParentFor(SortedMap orderSetsByGroup, DeweyOrderSet deweyOrderSet) {
        String parentGroup = deweyOrderSet.getGroupPath();
        DeweyOrderSet parentOrderSet = (DeweyOrderSet)orderSetsByGroup.get(parentGroup);
        if (parentOrderSet == null) {
            parentOrderSet = new DeweyOrderSet(parentGroup);
            orderSetsByGroup.put(parentGroup, parentOrderSet);
            if (!parentGroup.equals("")) {
                DeweyOrderSet.ensureParentFor(orderSetsByGroup, deweyOrderSet);
            }
        }
        if (deweyOrderSet != parentOrderSet) {
            deweyOrderSet.setParent(parentOrderSet);
            parentOrderSet.addChild(deweyOrderSet);
        }
    }

    private static SortedSet<FacetedMethod> getSortedSet(SortedMap<String, SortedSet<FacetedMethod>> sortedMembersByGroup, String groupName) {
        TreeSet<Object> sortedMembersForGroup = (TreeSet<Object>)sortedMembersByGroup.get(groupName);
        if (sortedMembersForGroup == null) {
            sortedMembersForGroup = new TreeSet<Object>(new MemberOrderComparator(true));
            sortedMembersByGroup.put(groupName, sortedMembersForGroup);
        }
        return sortedMembersForGroup;
    }

    private DeweyOrderSet(String groupName) {
        super(groupName);
    }

    public String toString() {
        return this.getGroupFullName() + ":" + this.size() + "el/" + (this.size() - this.childOrderSets.size()) + "m/" + this.childOrderSets.size() + "ch";
    }
}

