/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.DeweyOrderSet;

public class OrderSet
implements Comparable<OrderSet>,
Iterable<Object> {
    private final List<Object> elements = Lists.newArrayList();
    private final String groupFullName;
    private final String groupName;
    private final String groupPath;
    private OrderSet parent;
    protected SortedSet<DeweyOrderSet> childOrderSets = new TreeSet<DeweyOrderSet>();

    public OrderSet(String groupFullName) {
        this.groupFullName = groupFullName;
        this.groupName = OrderSet.deriveGroupName(groupFullName);
        this.groupPath = OrderSet.deriveGroupPath(groupFullName);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupFullName() {
        return this.groupFullName;
    }

    public String getGroupPath() {
        return this.groupPath;
    }

    private static String deriveGroupName(String groupFullName) {
        String groupSimpleName;
        StringTokenizer tokens = new StringTokenizer(groupFullName, ",", false);
        String[] groupNameComponents = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            groupNameComponents[i] = tokens.nextToken();
            ++i;
        }
        String string = groupSimpleName = groupNameComponents.length > 0 ? groupNameComponents[groupNameComponents.length - 1] : "";
        if (groupSimpleName.length() > 1) {
            return groupSimpleName.substring(0, 1).toUpperCase() + groupSimpleName.substring(1);
        }
        return groupSimpleName.toUpperCase();
    }

    private static String deriveGroupPath(String groupFullName) {
        int lastComma = groupFullName.lastIndexOf(",");
        if (lastComma == -1) {
            return "";
        }
        return groupFullName.substring(0, lastComma);
    }

    protected void setParent(DeweyOrderSet parent) {
        this.parent = parent;
    }

    public OrderSet getParent() {
        return this.parent;
    }

    protected void addChild(DeweyOrderSet childOrderSet) {
        this.childOrderSets.add(childOrderSet);
    }

    public List<DeweyOrderSet> children() {
        ArrayList<DeweyOrderSet> list = new ArrayList<DeweyOrderSet>();
        list.addAll(this.childOrderSets);
        return list;
    }

    protected void copyOverChildren() {
        this.addAll(this.childOrderSets);
    }

    public List<Object> elementList() {
        return new ArrayList<Object>(this.elements);
    }

    public int size() {
        return this.elements.size();
    }

    protected void addElement(Object element) {
        this.elements.add(element);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.elements.iterator();
    }

    protected void addAll(SortedSet<?> sortedMembers) {
        for (Object deweyOrderSet : sortedMembers) {
            this.addElement(deweyOrderSet);
        }
    }

    @Override
    public int compareTo(OrderSet o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.groupFullName.compareTo(o.groupFullName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderSet other = (OrderSet)obj;
        return !(this.groupFullName == null ? other.groupFullName != null : !this.groupFullName.equals(other.groupFullName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupFullName == null ? 0 : this.groupFullName.hashCode());
        return result;
    }
}

