/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.layout;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.layout.MemberLayoutArranger;
import org.apache.isis.core.metamodel.layout.OrderSet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.log4j.Logger;

public abstract class MemberLayoutArrangerComposite
implements MemberLayoutArranger {
    private static final Logger LOG = Logger.getLogger(MemberLayoutArrangerComposite.class);
    private final List<MemberLayoutArranger> arrangers = Lists.newArrayList();

    public MemberLayoutArrangerComposite(MemberLayoutArranger ... arrangers) {
        this.arrangers.addAll(Arrays.asList(arrangers));
    }

    @Override
    public OrderSet createAssociationOrderSetFor(ObjectSpecification spec, List<FacetedMethod> associationMethods) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MemberLayoutArrangerComposite: createAssociationOrderSetFor " + spec.getFullIdentifier()));
        }
        for (MemberLayoutArranger arranger : this.arrangers) {
            OrderSet orderSet = arranger.createAssociationOrderSetFor(spec, associationMethods);
            if (orderSet == null) continue;
            return orderSet;
        }
        return null;
    }

    @Override
    public OrderSet createActionOrderSetFor(ObjectSpecification spec, List<FacetedMethod> actionMethods) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MemberLayoutArrangerDefault: createAssociationOrderSetFor " + spec.getFullIdentifier()));
        }
        for (MemberLayoutArranger arranger : this.arrangers) {
            OrderSet orderSet = arranger.createActionOrderSetFor(spec, actionMethods);
            if (orderSet == null) continue;
            return orderSet;
        }
        return null;
    }
}

