/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.interactions;

import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionContextType;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;

public abstract class InteractionContext<T extends InteractionEvent> {
    private final InteractionContextType interactionType;
    private final Identifier identifier;
    private final InteractionInvocationMethod invocation;
    private final AuthenticationSession session;
    private final ObjectAdapter target;

    public InteractionContext(InteractionContextType interactionType, AuthenticationSession session, InteractionInvocationMethod invocationMethod, Identifier identifier, ObjectAdapter target) {
        this.interactionType = interactionType;
        this.invocation = invocationMethod;
        this.identifier = identifier;
        this.session = session;
        this.target = target;
    }

    public InteractionContextType getInteractionType() {
        return this.interactionType;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public AuthenticationSession getSession() {
        return this.session;
    }

    public InteractionInvocationMethod getInvocationMethod() {
        return this.invocation;
    }

    public boolean isProgrammatic() {
        return this.invocation == InteractionInvocationMethod.PROGRAMMATIC;
    }

    public ObjectAdapter getTarget() {
        return this.target;
    }

    public abstract T createInteractionEvent();
}

