/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.interactions;

import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.events.ActionArgumentEvent;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterUtils;
import org.apache.isis.core.metamodel.consent.InteractionContextType;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.interactions.ProposedHolder;
import org.apache.isis.core.metamodel.interactions.ValidityContext;

public class ActionArgumentContext
extends ValidityContext<ActionArgumentEvent>
implements ProposedHolder {
    private final ObjectAdapter[] args;
    private final int position;
    private final ObjectAdapter proposed;

    public ActionArgumentContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter target, Identifier id, ObjectAdapter[] args, int position) {
        super(InteractionContextType.ACTION_PROPOSED_ARGUMENT, session, invocationMethod, id, target);
        this.args = args;
        this.position = position;
        this.proposed = args[position];
    }

    public ObjectAdapter[] getArgs() {
        return this.args;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public ObjectAdapter getProposed() {
        return this.proposed;
    }

    @Override
    public ActionArgumentEvent createInteractionEvent() {
        return new ActionArgumentEvent(AdapterUtils.unwrap(this.getTarget()), this.getIdentifier(), AdapterUtils.unwrap(this.getArgs()), this.getPosition());
    }
}

