/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.notpersistable;

import org.apache.isis.applib.annotation.NotPersistable;
import org.apache.isis.applib.marker.NonPersistable;
import org.apache.isis.applib.marker.ProgramPersistable;
import org.apache.isis.core.metamodel.facets.EnumerationAbstract;

public final class InitiatedBy
extends EnumerationAbstract {
    public static InitiatedBy USER = new InitiatedBy(0, "USER", "User");
    public static InitiatedBy USER_OR_PROGRAM = new InitiatedBy(1, "USER_OR_PROGRAM", "User or Program");

    private InitiatedBy(int num, String nameInCode, String friendlyName) {
        super(num, nameInCode, friendlyName);
    }

    public static InitiatedBy decodeBy(NotPersistable.By by) {
        if (by == NotPersistable.By.USER) {
            return USER;
        }
        if (by == NotPersistable.By.USER_OR_PROGRAM) {
            return USER_OR_PROGRAM;
        }
        return null;
    }

    public static InitiatedBy forCorrespondingMarkerSubType(Class<?> cls) {
        InitiatedBy initiatedBy = null;
        if (ProgramPersistable.class.isAssignableFrom(cls)) {
            initiatedBy = USER;
        } else if (NonPersistable.class.isAssignableFrom(cls)) {
            initiatedBy = USER_OR_PROGRAM;
        }
        return initiatedBy;
    }
}

