/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.immutable;

import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.SingleWhenValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.When;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;

public abstract class ImmutableFacetAbstract
extends SingleWhenValueFacetAbstract
implements ImmutableFacet {
    public static Class<? extends Facet> type() {
        return ImmutableFacet.class;
    }

    public ImmutableFacetAbstract(When value, FacetHolder holder) {
        super(ImmutableFacetAbstract.type(), holder, value);
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        ObjectAdapter target = ic.getTarget();
        switch (ic.getInteractionType()) {
            case PROPERTY_MODIFY: 
            case COLLECTION_ADD_TO: 
            case COLLECTION_REMOVE_FROM: {
                return this.disabledReason(target);
            }
        }
        return null;
    }

    public String disabledReason(ObjectAdapter targetAdapter) {
        if (this.value() == When.ALWAYS) {
            return "Always immmutable";
        }
        if (this.value() == When.NEVER) {
            return null;
        }
        if (targetAdapter == null) {
            return null;
        }
        if (this.value() == When.UNTIL_PERSISTED) {
            return targetAdapter.isTransient() ? "Immutable until persisted" : null;
        }
        if (this.value() == When.ONCE_PERSISTED) {
            return targetAdapter.isPersistent() ? "Immutable once persisted" : null;
        }
        return null;
    }
}

