/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.maxlen;

import org.apache.isis.applib.events.ValidityEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.SingleIntValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.interactions.ProposedHolder;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.spec.ObjectAdapterUtils;

public abstract class MaxLengthFacetAbstract
extends SingleIntValueFacetAbstract
implements MaxLengthFacet {
    public static Class<? extends Facet> type() {
        return MaxLengthFacet.class;
    }

    public MaxLengthFacetAbstract(int value, FacetHolder holder) {
        super(MaxLengthFacetAbstract.type(), holder, value);
    }

    @Override
    public boolean exceeds(ObjectAdapter adapter) {
        String str = ObjectAdapterUtils.unwrapString(adapter);
        if (str == null) {
            return false;
        }
        int maxLength = this.value();
        return maxLength != 0 && str.length() > maxLength;
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> context) {
        if (!(context instanceof ProposedHolder)) {
            return null;
        }
        ProposedHolder proposedHolder = (ProposedHolder)((Object)context);
        ObjectAdapter proposedArgument = proposedHolder.getProposed();
        if (!this.exceeds(proposedArgument)) {
            return null;
        }
        return "Proposed value '" + proposedArgument.titleString() + "' exceeds the maximum length of " + this.value();
    }

    @Override
    protected String toStringValues() {
        int val = this.value();
        return val == 0 ? "unlimited" : String.valueOf(val);
    }
}

