/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import org.apache.isis.applib.marker.AlwaysImmutable;
import org.apache.isis.applib.marker.ImmutableOncePersisted;
import org.apache.isis.applib.marker.ImmutableUntilPersisted;
import org.apache.isis.applib.marker.NeverImmutable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.EnumerationAbstract;

public final class When
extends EnumerationAbstract {
    public static When ALWAYS = new When(0, "ALWAYS", "Always");
    public static When ONCE_PERSISTED = new When(1, "ONCE_PERSISTED", "Once Persisted");
    public static When UNTIL_PERSISTED = new When(1, "UNTIL_PERSISTED", "Until Persisted");
    public static When NEVER = new When(1, "NEVER", "Never");

    private When(int num, String nameInCode, String friendlyName) {
        super(num, nameInCode, friendlyName);
    }

    public boolean isNowFor(ObjectAdapter targetAdapter) {
        boolean isTransient = targetAdapter.isTransient();
        return this == ALWAYS || this == ONCE_PERSISTED && !isTransient || this == UNTIL_PERSISTED && isTransient;
    }

    public static When forCorrespondingMarkerSubType(Class<?> cls) {
        if (AlwaysImmutable.class.isAssignableFrom(cls)) {
            return ALWAYS;
        }
        if (ImmutableOncePersisted.class.isAssignableFrom(cls)) {
            return ONCE_PERSISTED;
        }
        if (ImmutableUntilPersisted.class.isAssignableFrom(cls)) {
            return UNTIL_PERSISTED;
        }
        if (NeverImmutable.class.isAssignableFrom(cls)) {
            return NEVER;
        }
        return null;
    }

    public static When decode(org.apache.isis.applib.annotation.When when) {
        if (when == org.apache.isis.applib.annotation.When.ALWAYS) {
            return ALWAYS;
        }
        if (when == org.apache.isis.applib.annotation.When.ONCE_PERSISTED) {
            return ONCE_PERSISTED;
        }
        if (when == org.apache.isis.applib.annotation.When.UNTIL_PERSISTED) {
            return UNTIL_PERSISTED;
        }
        return NEVER;
    }
}

