/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.SingleClassValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;

public abstract class SingleClassValueFacetAbstract
extends FacetAbstract
implements SingleClassValueFacet {
    private final Class<?> value;
    private final SpecificationLookup specificationLookup;

    public SingleClassValueFacetAbstract(Class<? extends Facet> facetType, FacetHolder holder, Class<?> value, SpecificationLookup specificationLookup) {
        super(facetType, holder, false);
        this.value = value;
        this.specificationLookup = specificationLookup;
    }

    @Override
    public Class<?> value() {
        return this.value;
    }

    @Override
    public ObjectSpecification valueSpec() {
        Class<?> valueType = this.value();
        return valueType != null ? this.getSpecificationLookup().loadSpecification(valueType) : null;
    }

    private SpecificationLookup getSpecificationLookup() {
        return this.specificationLookup;
    }
}

