/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.commons.lang.CastUtils;
import org.apache.isis.core.metamodel.facetapi.DecoratingFacet;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;

public final class ImperativeFacetUtils {
    private ImperativeFacetUtils() {
    }

    public static ImperativeFacet getImperativeFacet(Facet facet) {
        if (facet instanceof ImperativeFacet) {
            return (ImperativeFacet)((Object)facet);
        }
        if (facet instanceof DecoratingFacet) {
            DecoratingFacet decoratingFacet = (DecoratingFacet)CastUtils.cast((Object)facet);
            return ImperativeFacetUtils.getImperativeFacet(decoratingFacet.getDecoratedFacet());
        }
        return null;
    }

    public static boolean isImperativeFacet(Facet facet) {
        return ImperativeFacetUtils.getImperativeFacet(facet) != null;
    }

    public static ImperativeFacetFlags getImperativeFacetFlags(ObjectMember member, Method method) {
        ImperativeFacetFlags flags = new ImperativeFacetFlags();
        if (member == null) {
            return flags;
        }
        List<Facet> allFacets = member.getFacets((Filter<Facet>)Filters.anyOfType(Facet.class));
        for (Facet facet : allFacets) {
            List<Method> methods;
            ImperativeFacet imperativeFacet = ImperativeFacetUtils.getImperativeFacet(facet);
            if (imperativeFacet == null || !(methods = imperativeFacet.getMethods()).contains(method)) continue;
            flags.apply(imperativeFacet);
            if (!flags.bothSet()) continue;
            break;
        }
        return flags;
    }

    public static class ImperativeFacetFlags {
        private boolean impliesResolve;
        private boolean impliesObjectChanged;

        public void apply(ImperativeFacet imperativeFacet) {
            this.impliesResolve |= imperativeFacet.impliesResolve();
            this.impliesObjectChanged |= imperativeFacet.impliesObjectChanged();
        }

        public boolean bothSet() {
            return this.impliesResolve && this.impliesObjectChanged;
        }

        public boolean impliesResolve() {
            return this.impliesResolve;
        }

        public boolean impliesObjectChanged() {
            return this.impliesObjectChanged;
        }
    }
}

