/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.Debuggable;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.TypedHolderDefault;

public class FacetedMethod
extends TypedHolderDefault
implements IdentifiedHolder,
Debuggable {
    private final Class<?> owningType;
    private final Method method;
    private final Identifier identifier;
    private final List<FacetedMethodParameter> parameters;

    public static FacetedMethod createPropertyFacetedMethod(Class<?> declaringType, Method method) {
        return new FacetedMethod(FeatureType.PROPERTY, declaringType, method, method.getReturnType(), FacetedMethod.emptyParameterList());
    }

    public static FacetedMethod createProperty(Class<?> owningClass, String name) {
        try {
            Method method = owningClass.getMethod("get" + StringUtils.pascal((String)name), new Class[0]);
            return FacetedMethod.createPropertyFacetedMethod(owningClass, method);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static FacetedMethod createCollectionFacetedMethod(Class<?> declaringType, Method method) {
        return new FacetedMethod(FeatureType.COLLECTION, declaringType, method, null, FacetedMethod.emptyParameterList());
    }

    public static FacetedMethod createActionFacetedMethod(Class<?> declaringType, Method method) {
        return new FacetedMethod(FeatureType.ACTION, declaringType, method, method.getReturnType(), FacetedMethod.getParameters(method));
    }

    private static List<FacetedMethodParameter> getParameters(Method actionMethod) {
        Class<?>[] parameterTypes = actionMethod.getParameterTypes();
        ArrayList actionParams = Lists.newArrayList();
        for (Class<?> parameterType : parameterTypes) {
            actionParams.add(new FacetedMethodParameter(parameterType));
        }
        return Collections.unmodifiableList(actionParams);
    }

    public List<FacetedMethodParameter> getParameters() {
        return this.parameters;
    }

    public static List<FacetedMethodParameter> emptyParameterList() {
        List emptyList = Collections.emptyList();
        return Collections.unmodifiableList(emptyList);
    }

    private FacetedMethod(FeatureType featureType, Class<?> declaringType, Method method, Class<?> type, List<FacetedMethodParameter> parameters) {
        super(featureType, type);
        this.owningType = declaringType;
        this.method = method;
        this.identifier = featureType.identifierFor(declaringType, method);
        this.parameters = parameters;
    }

    public Class<?> getOwningType() {
        return this.owningType;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.getFeatureType().name() + " Peer [identifier=\"" + this.getIdentifier() + "\",type=" + this.getType().getName() + " ]";
    }

    public void debugData(DebugBuilder debug) {
    }
}

