/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public interface FacetFactory {
    public List<FeatureType> getFeatureTypes();

    public void process(ProcessClassContext var1);

    public void process(ProcessMethodContext var1);

    public void processParams(ProcessParameterContext var1);

    public static class ProcessParameterContext
    extends AbstractProcessContext<FacetedMethodParameter> {
        private final Method method;
        private final int paramNum;

        public ProcessParameterContext(Method method, int paramNum, FacetedMethodParameter facetedMethodParameter) {
            super(facetedMethodParameter);
            this.method = method;
            this.paramNum = paramNum;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getParamNum() {
            return this.paramNum;
        }
    }

    public static class ProcessMethodContext
    extends AbstractProcessContext<FacetedMethod>
    implements MethodRemover {
        private final Class<?> cls;
        private final Method method;
        private final MethodRemover methodRemover;

        public ProcessMethodContext(Class<?> cls, Method method, MethodRemover methodRemover, FacetedMethod facetedMethod) {
            super(facetedMethod);
            this.cls = cls;
            this.method = method;
            this.methodRemover = methodRemover;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public List<Method> removeMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
            return this.methodRemover.removeMethods(methodScope, prefix, returnType, canBeVoid, paramCount);
        }

        @Override
        public void removeMethod(MethodScope methodScope, String methodName, Class<?> returnType, Class<?>[] parameterTypes) {
            this.methodRemover.removeMethod(methodScope, methodName, returnType, parameterTypes);
        }

        @Override
        public void removeMethod(Method method) {
            this.methodRemover.removeMethod(method);
        }

        @Override
        public void removeMethods(List<Method> methods) {
            this.methodRemover.removeMethods(methods);
        }
    }

    public static class ProcessClassContext
    extends AbstractProcessContext<FacetHolder>
    implements MethodRemover {
        private final Class<?> cls;
        private final MethodRemover methodRemover;

        public ProcessClassContext(Class<?> cls, MethodRemover methodRemover, FacetHolder facetHolder) {
            super(facetHolder);
            this.cls = cls;
            this.methodRemover = methodRemover;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        @Override
        public void removeMethod(Method method) {
            this.methodRemover.removeMethod(method);
        }

        @Override
        public List<Method> removeMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
            return this.methodRemover.removeMethods(methodScope, prefix, returnType, canBeVoid, paramCount);
        }

        @Override
        public void removeMethod(MethodScope methodScope, String methodName, Class<?> returnType, Class<?>[] parameterTypes) {
            this.methodRemover.removeMethod(methodScope, methodName, returnType, parameterTypes);
        }

        @Override
        public void removeMethods(List<Method> methods) {
            this.methodRemover.removeMethods(methods);
        }
    }

    public static class AbstractProcessContext<T extends FacetHolder> {
        private final T facetHolder;

        public AbstractProcessContext(T facetHolder) {
            this.facetHolder = facetHolder;
        }

        public T getFacetHolder() {
            return this.facetHolder;
        }
    }
}

