/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;

public abstract class AnnotationBasedFacetFactoryAbstract
extends FacetFactoryAbstract {
    public AnnotationBasedFacetFactoryAbstract(List<FeatureType> featureTypes) {
        super(featureTypes);
    }

    public boolean recognizes(Method method) {
        return false;
    }

    protected boolean isString(Class<?> cls) {
        return cls.equals(String.class);
    }

    protected static <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (cls == null) {
            return null;
        }
        T annotation = cls.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            try {
                T annotationFromSuperclass = AnnotationBasedFacetFactoryAbstract.getAnnotation(superclass, annotationClass);
                if (annotationFromSuperclass != null) {
                    return annotationFromSuperclass;
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            T annotationFromInterface = AnnotationBasedFacetFactoryAbstract.getAnnotation(iface, annotationClass);
            if (annotationFromInterface == null) continue;
            return annotationFromInterface;
        }
        return null;
    }

    protected static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (method == null) {
            return null;
        }
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return AnnotationBasedFacetFactoryAbstract.getAnnotation(parentClassMethod, annotationClass);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return AnnotationBasedFacetFactoryAbstract.getAnnotation(ifaceMethod, annotationClass);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass) {
        Class<?>[] interfaces;
        if (method == null) {
            return false;
        }
        boolean present = method.isAnnotationPresent(annotationClass);
        if (present) {
            return true;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return AnnotationBasedFacetFactoryAbstract.isAnnotationPresent(parentClassMethod, annotationClass);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return AnnotationBasedFacetFactoryAbstract.isAnnotationPresent(ifaceMethod, annotationClass);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return false;
    }

    protected static Annotation[][] getParameterAnnotations(Method method) {
        Class<?>[] interfaces;
        if (method == null) {
            return new Annotation[0][0];
        }
        Annotation[][] allParamAnnotations = method.getParameterAnnotations();
        boolean foundAnnotationsForAnyParameter = false;
        for (Annotation[] singleParamAnnotations : allParamAnnotations) {
            if (singleParamAnnotations.length <= 0) continue;
            foundAnnotationsForAnyParameter = true;
            break;
        }
        if (foundAnnotationsForAnyParameter) {
            return allParamAnnotations;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return AnnotationBasedFacetFactoryAbstract.getParameterAnnotations(parentClassMethod);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return AnnotationBasedFacetFactoryAbstract.getParameterAnnotations(ifaceMethod);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return AnnotationBasedFacetFactoryAbstract.noParamAnnotationsFor(method);
    }

    private static Annotation[][] noParamAnnotationsFor(Method method) {
        return new Annotation[method.getParameterTypes().length][0];
    }
}

