/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.consent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.core.metamodel.consent.Allow;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionAdvisor;
import org.apache.isis.core.metamodel.consent.Veto;

public class InteractionResult {
    private final InteractionEvent interactionEvent;
    private final StringBuilder reasonBuf = new StringBuilder();
    private final List<InteractionAdvisor> advisors = new ArrayList<InteractionAdvisor>();
    private State state = State.ADVISING;

    public InteractionResult(InteractionEvent interactionEvent) {
        this.interactionEvent = interactionEvent;
    }

    public InteractionEvent getInteractionEvent() {
        if (this.state == State.ADVISING) {
            this.interactionEvent.advised(this.getReason(), this.getAdvisorClass());
            this.state = State.ADVISED;
        }
        return this.interactionEvent;
    }

    private Class<?> getAdvisorClass() {
        InteractionAdvisor advisor = this.getAdvisor();
        return advisor != null ? advisor.getClass() : null;
    }

    public void advise(String reason, InteractionAdvisor facet) {
        if (this.state == State.ADVISED) {
            throw new IllegalStateException("Cannot append since have called getInteractionEvent");
        }
        if (reason == null) {
            return;
        }
        if (this.isVetoing()) {
            this.reasonBuf.append("; ");
        }
        this.advisors.add(facet);
        this.reasonBuf.append(reason);
    }

    public boolean isVetoing() {
        return !this.isNotVetoing();
    }

    public boolean isNotVetoing() {
        return this.reasonBuf.length() == 0;
    }

    public InteractionAdvisor getAdvisor() {
        return this.advisors.size() >= 1 ? this.advisors.get(0) : null;
    }

    public List<InteractionAdvisor> getAdvisorFacets() {
        return Collections.unmodifiableList(this.advisors);
    }

    public Consent createConsent() {
        if (this.isNotVetoing()) {
            return new Allow(this);
        }
        return new Veto(this);
    }

    public String getReason() {
        return this.isNotVetoing() ? null : this.reasonBuf.toString();
    }

    public String toString() {
        return String.format("%s: %s: %s (%d facets advised)", new Object[]{this.interactionEvent, this.state, this.toStringInterpret(this.reasonBuf), this.advisors.size()});
    }

    private String toStringInterpret(StringBuilder reasonBuf) {
        if (this.getReason().length() == 0) {
            return "allowed";
        }
        return "vetoed";
    }

    static enum State {
        ADVISING,
        ADVISED;

    }
}

