/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.consent;

import java.io.Serializable;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.matchers.IsisMatchers;
import org.apache.isis.core.metamodel.consent.Allow;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.consent.Veto;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class ConsentAbstract
implements Serializable,
Consent {
    private static final long serialVersionUID = 1L;
    private final InteractionResult interactionResult;
    private final String reason;
    private String description;

    public static Consent allowIf(boolean allowed) {
        return allowed ? Allow.DEFAULT : Veto.DEFAULT;
    }

    private static String determineReason(InteractionResult interactionResult) {
        if (interactionResult == null) {
            return null;
        }
        return interactionResult.getReason();
    }

    protected ConsentAbstract(InteractionResult interactionResult) {
        this(interactionResult, null, ConsentAbstract.determineReason(interactionResult));
    }

    protected ConsentAbstract(String description, String reason) {
        this(null, description, reason);
    }

    private ConsentAbstract(InteractionResult interactionResult, String description, String reason) {
        this.interactionResult = interactionResult;
        this.description = description;
        Ensure.ensureThatArg((Object)reason, (Matcher)CoreMatchers.is((Matcher)IsisMatchers.nonEmptyStringOrNull()));
        this.reason = reason;
    }

    @Override
    public String getReason() {
        return this.isVetoed() ? this.reason : null;
    }

    @Override
    public Consent setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean isAllowed() {
        return this.reason == null || this.reason.equals("");
    }

    @Override
    public boolean isVetoed() {
        return !this.isAllowed();
    }

    @Override
    public InteractionResult getInteractionResult() {
        return this.interactionResult;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return (this.isVetoed() ? "VETOED" : "ALLOWED") + ", reason=" + this.reason;
    }
}

