/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;

public class AdapterUtils {
    private AdapterUtils() {
    }

    public static boolean exists(ObjectAdapter adapter) {
        return adapter != null && adapter.getObject() != null;
    }

    public static boolean wrappedEqual(ObjectAdapter adapter1, ObjectAdapter adapter2) {
        boolean defined1 = AdapterUtils.exists(adapter1);
        boolean defined2 = AdapterUtils.exists(adapter2);
        if (defined1 && !defined2) {
            return false;
        }
        if (!defined1 && defined2) {
            return false;
        }
        if (!defined1 && !defined2) {
            return true;
        }
        return adapter1.getObject().equals(adapter2.getObject());
    }

    public static Object unwrap(ObjectAdapter adapter) {
        return adapter != null ? adapter.getObject() : null;
    }

    public static Object[] unwrap(ObjectAdapter[] adapters) {
        if (adapters == null) {
            return null;
        }
        Object[] unwrappedObjects = new Object[adapters.length];
        int i = 0;
        for (ObjectAdapter adapter : adapters) {
            unwrappedObjects[i++] = AdapterUtils.unwrap(adapter);
        }
        return unwrappedObjects;
    }

    public static <T> List<T> unwrap(List<ObjectAdapter> adapters) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ObjectAdapter adapter : adapters) {
            list.add(AdapterUtils.unwrap(adapter));
        }
        return list;
    }

    public static String titleString(ObjectAdapter adapter) {
        return adapter != null ? adapter.titleString() : "";
    }

    public static boolean nullSafeEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.equals(obj2)) {
            return true;
        }
        if (obj1 instanceof ObjectAdapter && obj2 instanceof ObjectAdapter) {
            ObjectAdapter adapterObj1 = (ObjectAdapter)obj1;
            ObjectAdapter adapterObj2 = (ObjectAdapter)obj2;
            return AdapterUtils.nullSafeEquals(adapterObj1.getObject(), adapterObj2.getObject());
        }
        return false;
    }
}

