/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid.stringable.hex;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.isis.core.commons.encoding.DataInputStreamExtended;
import org.apache.isis.core.commons.encoding.DataOutputStreamExtended;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.stringable.OidStringifier;

public class OidStringifierHex
implements OidStringifier {
    @Override
    public String enString(Oid oid) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStreamExtended outputImpl = new DataOutputStreamExtended((OutputStream)baos);
        try {
            outputImpl.writeEncodable((Object)oid);
            byte[] byteArray = baos.toByteArray();
            return new String(Hex.encodeHex((byte[])byteArray));
        }
        catch (IOException e) {
            throw new IsisException("Failed to write object", (Throwable)e);
        }
    }

    @Override
    public Oid deString(String oidStr) {
        char[] oidCharArray = oidStr.toCharArray();
        try {
            byte[] oidBytes = Hex.decodeHex((char[])oidCharArray);
            ByteArrayInputStream bais = new ByteArrayInputStream(oidBytes);
            DataInputStreamExtended inputImpl = new DataInputStreamExtended((InputStream)bais);
            return (Oid)inputImpl.readEncodable(Oid.class);
        }
        catch (IOException ex) {
            throw new IsisException("Failed to read object", (Throwable)ex);
        }
        catch (DecoderException ex) {
            throw new IsisException("Failed to hex decode object", (Throwable)ex);
        }
    }
}

