/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid.stringable.directly;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.stringable.OidStringifier;
import org.apache.isis.core.metamodel.adapter.oid.stringable.directly.DirectlyStringableOid;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class OidStringifierDirect
implements OidStringifier {
    private final Class<? extends Oid> oidClass;
    private final Method deStringMethod;

    public OidStringifierDirect(Class<? extends Oid> oidClass) {
        Ensure.ensureThatArg(oidClass, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue(Class.class))));
        this.oidClass = oidClass;
        try {
            this.deStringMethod = oidClass.getMethod("deString", String.class);
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException("Trying to obtain 'deString(String)' method from  Oid class '" + oidClass.getName() + "'", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Trying to obtain 'deString(String)' method from  Oid class '" + oidClass.getName() + "'", ex);
        }
        if (!JavaClassUtils.isStatic((Method)this.deStringMethod)) {
            throw new IllegalArgumentException("'deString(String)' method for Oid class '" + oidClass.getName() + "' must be static");
        }
        if (!JavaClassUtils.isPublic((Method)this.deStringMethod)) {
            throw new IllegalArgumentException("'deString(String)' method for Oid class '" + oidClass.getName() + "' must be public");
        }
    }

    @Override
    public String enString(Oid oid) {
        if (!(oid instanceof DirectlyStringableOid)) {
            throw new IllegalArgumentException("Must be DirectlyStringableOid; oid class: " + oid.getClass().getName());
        }
        DirectlyStringableOid directlyStringableOid = (DirectlyStringableOid)oid;
        return directlyStringableOid.enString();
    }

    @Override
    public Oid deString(String oidStr) {
        try {
            return (Oid)this.deStringMethod.invoke(null, oidStr);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("deString(String) method failed; ", ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException("deString(String) method failed; ", ex);
        }
    }

    public Class<? extends Oid> getOidClass() {
        return this.oidClass;
    }

    public Method getDestringMethod() {
        return this.deStringMethod;
    }
}

