/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import java.io.IOException;
import java.io.Serializable;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.exceptions.NotYetImplementedException;
import org.apache.isis.core.metamodel.adapter.oid.Oid;

public final class AggregatedOid
implements Oid,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Oid parentOid;
    private final String id;
    private AggregatedOid previous;
    private int cachedHashCode;

    public AggregatedOid(Oid oid, String id) {
        Assert.assertNotNull((String)"ID required", (Object)id);
        this.parentOid = oid;
        this.id = id;
        this.initialized();
    }

    public AggregatedOid(DataInputExtended input) throws IOException {
        this.parentOid = (Oid)input.readEncodable(Oid.class);
        this.id = input.readUTF();
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeEncodable((Object)this.parentOid);
        output.writeUTF(this.id);
    }

    private void initialized() {
        this.cacheState();
    }

    public Oid getParentOid() {
        return this.parentOid;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void makePersistent() {
        this.previous = new AggregatedOid(this.parentOid, this.id);
        this.cacheState();
    }

    @Override
    public Oid getPrevious() {
        return this.previous;
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }

    @Override
    public void clearPrevious() {
    }

    @Override
    public void copyFrom(Oid oid) {
        throw new NotYetImplementedException();
    }

    @Override
    public boolean isTransient() {
        return this.parentOid.isTransient();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((AggregatedOid)other);
    }

    public boolean equals(AggregatedOid other) {
        return other.parentOid.equals(this.parentOid) && other.id.equals(this.id);
    }

    public int hashCode() {
        this.cacheState();
        return this.cachedHashCode;
    }

    private void cacheState() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.parentOid.hashCode();
        this.cachedHashCode = hashCode = 37 * hashCode + this.id.hashCode();
    }

    public String toString() {
        return "AOID[" + this.parentOid + "," + this.id + "]";
    }
}

